/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import java.io.IOException;
import java.util.Iterator;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import net.sf.jelly.apt.TemplateOutput;
import net.sf.jelly.apt.strategies.TemplateBlockStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateLoopStrategy<I, B extends TemplateBlock>
extends TemplateBlockStrategy<B> {
    private Iterator<I> loop = null;
    private int index = 0;

    protected abstract Iterator<I> getLoop(TemplateModel var1) throws TemplateException;

    protected void setupModelForLoop(TemplateModel model, I var, int index) throws TemplateException {
    }

    @Override
    public boolean preProcess(B block, TemplateOutput<B> output, TemplateModel model) throws IOException, TemplateException {
        boolean hasNext;
        super.preProcess(block, output, model);
        this.loop = this.getLoop(model);
        this.index = 0;
        boolean bl = hasNext = this.loop != null && this.loop.hasNext();
        if (hasNext) {
            this.setupModelForLoop(model, this.loop.next(), this.index++);
        }
        return hasNext;
    }

    @Override
    public boolean processBody(B block, TemplateOutput<B> output, TemplateModel model) throws IOException, TemplateException {
        if (this.loop == null) {
            throw new TemplateException("The body of a template loop cannot be processed without the loop!");
        }
        super.processBody(block, output, model);
        boolean hasNext = this.loop.hasNext();
        if (hasNext) {
            this.setupModelForLoop(model, this.loop.next(), this.index++);
        }
        return hasNext;
    }
}

