/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.decorations.declaration.AnnotationInvocationHandler;
import net.sf.jelly.apt.decorations.declaration.DecoratedAnnotationMirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratedDeclaration
implements Declaration {
    protected final Declaration delegate;
    protected final JavaDoc javaDoc;
    private HashMap<String, AnnotationMirror> annotations = null;

    public DecoratedDeclaration(Declaration delegate) {
        this.delegate = delegate;
        this.javaDoc = new JavaDoc(delegate.getDocComment());
    }

    public boolean isPublic() {
        return this.getModifiers().contains(Modifier.PUBLIC);
    }

    public boolean isProtected() {
        return this.getModifiers().contains(Modifier.PROTECTED);
    }

    public boolean isPrivate() {
        return this.getModifiers().contains(Modifier.PRIVATE);
    }

    public boolean isAbstract() {
        return this.getModifiers().contains(Modifier.ABSTRACT);
    }

    public boolean isStatic() {
        return this.getModifiers().contains(Modifier.STATIC);
    }

    public boolean isFinal() {
        return this.getModifiers().contains(Modifier.FINAL);
    }

    public boolean isTransient() {
        return this.getModifiers().contains(Modifier.TRANSIENT);
    }

    public boolean isVolatile() {
        return this.getModifiers().contains(Modifier.VOLATILE);
    }

    public boolean isSynchronized() {
        return this.getModifiers().contains(Modifier.SYNCHRONIZED);
    }

    public boolean isNative() {
        return this.getModifiers().contains(Modifier.NATIVE);
    }

    public boolean isStrictfp() {
        return this.getModifiers().contains(Modifier.STRICTFP);
    }

    public JavaDoc getJavaDoc() {
        return this.javaDoc;
    }

    public String getDocValue() {
        String value = this.javaDoc.toString();
        if (value != null && "".equals(value = value.trim())) {
            value = null;
        }
        return value;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new HashMap();
            for (AnnotationMirror annotationMirror : this.getAnnotationMirrors()) {
                AnnotationType annotationType = annotationMirror.getAnnotationType();
                if (annotationType == null || annotationType.getDeclaration() == null) continue;
                this.annotations.put(annotationType.getDeclaration().getQualifiedName(), annotationMirror);
            }
        }
        return this.annotations;
    }

    public String getDocComment() {
        return this.delegate.getDocComment();
    }

    public Collection<AnnotationMirror> getAnnotationMirrors() {
        return DeclarationDecorator.decorateAnnotationMirrors(this.delegate.getAnnotationMirrors());
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        DecoratedAnnotationMirror annotationMirror = (DecoratedAnnotationMirror)this.getAnnotations().get(annotationType.getName());
        if (annotationMirror != null) {
            AnnotationInvocationHandler handler = new AnnotationInvocationHandler(annotationType, annotationMirror);
            return (A)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)handler));
        }
        return null;
    }

    public Collection<Modifier> getModifiers() {
        return this.delegate.getModifiers();
    }

    public String getSimpleName() {
        return this.delegate.getSimpleName();
    }

    public SourcePosition getPosition() {
        return this.delegate.getPosition();
    }

    public void accept(DeclarationVisitor v) {
        v.visitDeclaration((Declaration)this);
    }

    public Declaration getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DecoratedDeclaration) {
            return this.equals(((DecoratedDeclaration)obj).delegate);
        }
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

