/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.waits;

import java.time.Duration;
import net.serenitybdd.screenplay.SilentInteraction;
import net.serenitybdd.screenplay.waits.WithTimeUnits;

public abstract class WaitWithTimeout
extends SilentInteraction {
    protected Duration timeout;

    public TimeoutBuilder forNoMoreThan(long timeout) {
        return new TimeoutBuilder(timeout, this);
    }

    public <T extends WaitWithTimeout> T forNoMoreThan(Duration timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public static class TimeoutBuilder
    implements WithTimeUnits {
        private final WaitWithTimeout waitWithTimeout;
        private final long duration;

        public TimeoutBuilder(long duration, WaitWithTimeout waitWithTimeout) {
            this.waitWithTimeout = waitWithTimeout;
            this.duration = duration;
        }

        @Override
        public WaitWithTimeout seconds() {
            this.waitWithTimeout.timeout = Duration.ofSeconds(this.duration);
            return this.waitWithTimeout;
        }

        @Override
        public WaitWithTimeout milliseconds() {
            this.waitWithTimeout.timeout = Duration.ofMillis(this.duration);
            return this.waitWithTimeout;
        }

        @Override
        public WaitWithTimeout minutes() {
            this.waitWithTimeout.timeout = Duration.ofMinutes(this.duration);
            return this.waitWithTimeout;
        }
    }
}

