/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.screenplay.questions.converters.converters.BigDecimalConverter;
import net.serenitybdd.screenplay.questions.converters.converters.BooleanConverter;
import net.serenitybdd.screenplay.questions.converters.converters.Converter;
import net.serenitybdd.screenplay.questions.converters.converters.DateTimeConverter;
import net.serenitybdd.screenplay.questions.converters.converters.DoubleConverter;
import net.serenitybdd.screenplay.questions.converters.converters.FloatConverter;
import net.serenitybdd.screenplay.questions.converters.converters.IntegerConverter;
import net.serenitybdd.screenplay.questions.converters.converters.LongConverter;
import net.serenitybdd.screenplay.questions.converters.converters.StringConverter;
import org.joda.time.DateTime;

public class DefaultConverters {
    protected static final Map<Class<?>, Converter<?>> DEFAULT_CONVERTERS = new HashMap();

    public static Converter<?> converterFor(Class<?> type) {
        Preconditions.checkState((boolean)DEFAULT_CONVERTERS.containsKey(type), (Object)("No converter found for " + type));
        return DEFAULT_CONVERTERS.get(type);
    }

    static {
        DEFAULT_CONVERTERS.put(String.class, new StringConverter());
        DEFAULT_CONVERTERS.put(Boolean.class, new BooleanConverter());
        DEFAULT_CONVERTERS.put(DateTime.class, new DateTimeConverter());
        DEFAULT_CONVERTERS.put(Float.class, new FloatConverter());
        DEFAULT_CONVERTERS.put(Double.class, new DoubleConverter());
        DEFAULT_CONVERTERS.put(Integer.class, new IntegerConverter());
        DEFAULT_CONVERTERS.put(Long.class, new LongConverter());
        DEFAULT_CONVERTERS.put(BigDecimal.class, new BigDecimalConverter());
    }
}

