/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.Optional;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.Performable;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.events.CastActorEvent;
import net.thucydides.core.steps.events.StepEventBusEvent;
import net.thucydides.core.steps.events.StepFailedEvent;
import net.thucydides.core.steps.events.StepFinishedEvent;
import net.thucydides.core.steps.events.StepStartedEvent;
import net.thucydides.core.steps.events.UpdateOverallResultsEvent;
import net.thucydides.core.steps.session.TestSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBusInterface.class);

    public static void castActor(String name) {
        if (!StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            return;
        }
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getEventBus().castActor(name);
        } else {
            TestSession.addEvent((StepEventBusEvent)new CastActorEvent(name));
        }
    }

    public void reportStepFailureFor(Performable todo, Throwable e) {
        ExecutedStepDescription taskDescription = ExecutedStepDescription.of(todo.getClass(), (String)"attemptsTo");
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getEventBus().stepFailed(new StepFailure(taskDescription, e));
        } else {
            TestSession.addEvent((StepEventBusEvent)new StepFailedEvent(new StepFailure(taskDescription, e)));
        }
    }

    public <T> void reportStepFailureFor(Consequence<T> consequence, Throwable e) {
        ExecutedStepDescription consequenceDescription = ExecutedStepDescription.withTitle((String)consequence.toString());
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getEventBus().stepFailed(new StepFailure(consequenceDescription, e));
        } else {
            TestSession.addEvent((StepEventBusEvent)new StepFailedEvent(new StepFailure(consequenceDescription, e)));
        }
    }

    public int getRunningStepCount() {
        return StepEventBus.getEventBus().getBaseStepListener().getRunningStepCount();
    }

    public void mergePreviousStep() {
        StepEventBus.getEventBus().mergePreviousStep();
    }

    public void updateOverallResult() {
        if (StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            if (!TestSession.isSessionStarted()) {
                StepEventBus.getEventBus().updateOverallResults();
            } else {
                TestSession.addEvent((StepEventBusEvent)new UpdateOverallResultsEvent());
            }
        }
    }

    public void startQuestion(String title) {
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)title).asAQuestion());
        } else {
            TestSession.addEvent((StepEventBusEvent)new StepStartedEvent(ExecutedStepDescription.withTitle((String)title).asAQuestion()));
        }
    }

    public void finishQuestion() {
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getEventBus().stepFinished();
        } else {
            TestSession.addEvent((StepEventBusEvent)new StepFinishedEvent());
        }
    }

    public void reportStepFinished() {
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getEventBus().stepFinished();
        } else {
            TestSession.addEvent((StepEventBusEvent)new StepFinishedEvent());
        }
    }

    public void reportStepIgnored() {
        StepEventBus.getEventBus().stepIgnored();
    }

    public void reportStepSkippedFor(Performable todo) {
        ExecutedStepDescription taskDescription = ExecutedStepDescription.of(todo.getClass(), (String)"performAs");
        StepEventBus.getEventBus().stepStarted(taskDescription);
        StepEventBus.getEventBus().stepIgnored();
    }

    public boolean isBaseStepListenerRegistered() {
        return StepEventBus.getEventBus().isBaseStepListenerRegistered();
    }

    public boolean aStepHasFailed() {
        return this.isBaseStepListenerRegistered() && StepEventBus.getEventBus().getBaseStepListener().aStepHasFailed();
    }

    public boolean aStepHasFailedInTheCurrentExample() {
        return this.isBaseStepListenerRegistered() && StepEventBus.getEventBus().getBaseStepListener().aStepHasFailedInTheCurrentExample();
    }

    public FailureCause getFailureCause() {
        return StepEventBus.getEventBus().getBaseStepListener().getCurrentTestOutcome().getTestFailureCause();
    }

    public Optional<FailureCause> failureCause() {
        if (StepEventBus.getEventBus() == null || !StepEventBus.getEventBus().isBaseStepListenerRegistered() || StepEventBus.getEventBus().getBaseStepListener().getCurrentTestOutcome() == null) {
            return Optional.empty();
        }
        if (StepEventBus.getEventBus().getBaseStepListener().aStepHasFailed()) {
            if (StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome().isPresent()) {
                return Optional.ofNullable(StepEventBus.getEventBus().getBaseStepListener().getCurrentTestOutcome().getTestFailureCause());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public boolean shouldIgnoreConsequences() {
        if (StepEventBus.getEventBus().isDryRun()) {
            return true;
        }
        if (StepEventBus.getEventBus().softAssertsActive() && !StepEventBus.getEventBus().currentTestIsSuspended()) {
            return false;
        }
        return StepEventBus.getEventBus().currentTestIsSuspended() || StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed();
    }

    public void enableSoftAsserts() {
        StepEventBus.getEventBus().enableSoftAsserts();
    }

    public void disableSoftAsserts() {
        StepEventBus.getEventBus().disableSoftAsserts();
    }

    public void assignFactToActor(Actor actor, String fact) {
        if (!StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            return;
        }
        StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome().ifPresent(testOutcome -> testOutcome.assignFact(actor.getName(), fact));
    }

    public void assignAbilityToActor(Actor actor, String ability) {
        if (!StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            return;
        }
        if (StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome() == null) {
            return;
        }
        StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome().ifPresent(testOutcome -> testOutcome.assignAbility(actor.getName(), ability));
    }
}

