/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.parallel.Agent;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.thucydides.core.steps.StepEventBus;

public class InParallel {
    Actor[] cast;

    private InParallel(Actor[] actors) {
        this.cast = actors;
    }

    public static InParallel theActors(Actor ... actors) {
        return new InParallel(actors);
    }

    public static InParallel theActors(Collection<Actor> actors) {
        return new InParallel(actors.toArray(new Actor[0]));
    }

    public void perform(List<Runnable> tasks) {
        this.perform(tasks.toArray(new Runnable[0]));
    }

    public void perform(Runnable ... tasks) {
        this.perform("{0}", tasks);
    }

    public void perform(String stepName, Runnable ... tasks) {
        try {
            StepEventBus.getEventBus().registerAgents((Agent[])this.cast);
            Arrays.asList(tasks).parallelStream().forEach(Runnable::run);
        }
        finally {
            StepEventBus.getEventBus().mergeActivitiesToDefaultStepListener(stepName, (Agent[])this.cast);
            StepEventBus.getEventBus().dropAgents((Agent[])this.cast);
        }
    }

    public void eachAttemptTo(Performable ... tasks) {
        List<Runnable> runnableTasks = Arrays.stream(this.cast).map(actor -> () -> actor.attemptsTo(tasks)).collect(Collectors.toList());
        this.perform(runnableTasks.toArray(new Runnable[0]));
    }

    public void eachAttemptTo(Collection<Performable> tasks) {
        this.eachAttemptTo(tasks.toArray(new Performable[0]));
    }
}

