/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.Optional;
import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.BaseConsequence;
import net.serenitybdd.screenplay.Complaint;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.QuestionDiagnostics;
import net.serenitybdd.screenplay.QuestionSubject;
import net.serenitybdd.screenplay.conditions.SilentPerformable;
import net.serenitybdd.screenplay.events.ActorAsksQuestion;
import net.thucydides.core.steps.StepEventBus;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class BooleanQuestionConsequence<T>
extends BaseConsequence<T> {
    private final Question<Boolean> question;
    private final String subject;
    private static final SilentPerformable DO_NOTHING = new SilentPerformable();

    public BooleanQuestionConsequence(Question<Boolean> actual) {
        this(null, actual);
    }

    public BooleanQuestionConsequence(String subjectText, Question<Boolean> actual) {
        this.question = actual;
        this.subject = QuestionSubject.fromClass(actual.getClass()).andQuestion(actual).subject();
        this.subjectText = Optional.ofNullable(subjectText);
    }

    @Override
    public void evaluateFor(Actor actor) {
        if (this.thisStepShouldBeIgnored() && !StepEventBus.getEventBus().softAssertsActive()) {
            return;
        }
        Broadcaster.getEventBus().post((Object)new ActorAsksQuestion(this.question, actor.getName()));
        try {
            this.performSetupActionsAs(actor);
            MatcherAssert.assertThat((String)this.reason(), (Object)this.question.answeredBy(actor), (Matcher)Matchers.is((Object)true));
        }
        catch (Throwable actualError) {
            this.throwComplaintTypeErrorIfSpecified(this.errorFrom(actualError));
            this.throwDiagosticErrorIfProvided(this.errorFrom(actualError));
            throw actualError;
        }
    }

    private String reason() {
        return "Expected " + QuestionSubject.fromClass(this.question.getClass()).andQuestion(this.question).subject();
    }

    private void throwDiagosticErrorIfProvided(Error actualError) {
        if (this.question instanceof QuestionDiagnostics) {
            throw Complaint.from(((QuestionDiagnostics)((Object)this.question)).onError(), actualError);
        }
    }

    public String toString() {
        String template = this.explanation.orElse("Then %s");
        return this.addRecordedInputValuesTo(String.format(template, this.subjectText.orElse(this.subject)));
    }
}

