/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actors;

import com.google.common.base.Splitter;
import java.util.List;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.actors.Cast;
import net.serenitybdd.screenplay.actors.Stage;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;

public class OnStage {
    private static final String DEFAULT_PRONOUNS = "he,she,they,it";
    private static final String A_NEW_ACTOR = "An actor";
    private static final ThreadLocal<Stage> stage = new ThreadLocal();

    public static Stage setTheStage(Cast cast) {
        stage.set(new Stage(cast));
        return OnStage.stage();
    }

    public static Actor theActorCalled(String requiredActor) {
        if (OnStage.pronouns().contains(requiredActor)) {
            return OnStage.stage().theActorInTheSpotlight().usingPronoun(requiredActor);
        }
        if (OnStage.anActorIsOnStage() && OnStage.theActorInTheSpotlight().getName().equals(A_NEW_ACTOR)) {
            OnStage.theActorInTheSpotlight().assignName(requiredActor);
            return OnStage.theActorInTheSpotlight();
        }
        return OnStage.stage().shineSpotlightOn(requiredActor);
    }

    private static boolean anActorIsOnStage() {
        return OnStage.stage().anActorIsOnStage();
    }

    public static Actor aNewActor() {
        return OnStage.stage().shineSpotlightOn(A_NEW_ACTOR);
    }

    public static Actor theActor(String actorName) {
        return OnStage.theActorCalled(actorName);
    }

    public static Actor theActorInTheSpotlight() {
        return OnStage.stage().theActorInTheSpotlight();
    }

    public static void withCurrentActor(Performable ... performTasks) {
        OnStage.theActorInTheSpotlight().attemptsTo(performTasks);
    }

    private static Stage stage() {
        return stage.get();
    }

    public static void drawTheCurtain() {
        if (OnStage.stage() != null) {
            OnStage.stage().drawTheCurtain();
        }
    }

    private static List<String> pronouns() {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)ThucydidesSystemProperty.SCREENPLAY_PRONOUNS.from(environmentVariables, DEFAULT_PRONOUNS));
    }
}

