/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.waits;

import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.EventualConsequence;
import net.serenitybdd.screenplay.GivenWhenThen;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.SilentInteraction;
import net.serenitybdd.screenplay.waits.WithTimeUnits;
import net.serenitybdd.screenplay.waits.WithTimeout;
import org.hamcrest.Matcher;

public class Wait
extends SilentInteraction {
    private Question question;
    private Matcher matcher;
    private long timeout;

    private Wait(Question question, Matcher matcher, long timeout) {
        this.question = question;
        this.matcher = matcher;
        this.timeout = timeout;
    }

    public static WithTimeout until(Question question, Matcher matcher) {
        return new WaitBuilder(question, matcher);
    }

    @Override
    public <T extends Actor> void performAs(T actor) {
        actor.should(EventualConsequence.eventually(GivenWhenThen.seeThat(this.question, this.matcher)).waitingForNoLongerThan(this.timeout).milliseconds());
    }

    public static class WaitBuilder
    implements WithTimeout,
    WithTimeUnits {
        private Question question;
        private Matcher matcher;
        private long timeout;

        public WaitBuilder(Question question, Matcher matcher) {
            this.question = question;
            this.matcher = matcher;
        }

        @Override
        public WithTimeUnits forNoLongerThan(long timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        public WithTimeUnits forNoLongerThan(int timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        public Wait seconds() {
            return new Wait(this.question, this.matcher, this.timeout * 1000L);
        }

        @Override
        public Wait milliseconds() {
            return new Wait(this.question, this.matcher, this.timeout);
        }
    }
}

