/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import java.util.Arrays;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.actions.SelectStrategy;
import net.serenitybdd.screenplay.actions.selectactions.SelectByIndexFromBy;
import net.serenitybdd.screenplay.actions.selectactions.SelectByIndexFromElement;
import net.serenitybdd.screenplay.actions.selectactions.SelectByIndexFromTarget;
import net.serenitybdd.screenplay.actions.selectactions.SelectByValueFromBy;
import net.serenitybdd.screenplay.actions.selectactions.SelectByValueFromElement;
import net.serenitybdd.screenplay.actions.selectactions.SelectByValueFromTarget;
import net.serenitybdd.screenplay.actions.selectactions.SelectByVisibleTextFromBy;
import net.serenitybdd.screenplay.actions.selectactions.SelectByVisibleTextFromElement;
import net.serenitybdd.screenplay.actions.selectactions.SelectByVisibleTextFromTarget;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.By;

public class SelectFromOptions {
    private final SelectStrategy strategy;
    private String[] options;
    private String[] values;
    private Integer[] indexes;

    public SelectFromOptions(SelectStrategy strategy) {
        this.strategy = strategy;
    }

    public static SelectFromOptions byValue(String ... values) {
        SelectFromOptions selectFromOptions = new SelectFromOptions(SelectStrategy.ByValue);
        selectFromOptions.values = values;
        return selectFromOptions;
    }

    public static SelectFromOptions byVisibleText(String ... visibleTexts) {
        SelectFromOptions selectFromOptions = new SelectFromOptions(SelectStrategy.ByVisibleText);
        selectFromOptions.options = visibleTexts;
        return selectFromOptions;
    }

    public static SelectFromOptions byIndex(Integer ... indexValues) {
        SelectFromOptions selectFromOptions = new SelectFromOptions(SelectStrategy.ByIndex);
        selectFromOptions.indexes = indexValues;
        return selectFromOptions;
    }

    public Performable from(String cssOrXpathForElement) {
        return this.from(Target.the(cssOrXpathForElement).locatedBy(cssOrXpathForElement));
    }

    public Performable from(Target target) {
        switch (this.strategy) {
            case ByValue: {
                return new SelectByValueFromTarget(target, this.values);
            }
            case ByVisibleText: {
                return new SelectByVisibleTextFromTarget(target, this.options);
            }
            case ByIndex: {
                return new SelectByIndexFromTarget(target, this.indexes);
            }
        }
        throw new IllegalStateException("Unknown select strategy " + (Object)((Object)this.strategy));
    }

    public Performable from(WebElementFacade element) {
        switch (this.strategy) {
            case ByValue: {
                return new SelectByValueFromElement(element, this.values);
            }
            case ByVisibleText: {
                return new SelectByVisibleTextFromElement(element, this.options);
            }
            case ByIndex: {
                return new SelectByIndexFromElement(element, this.indexes);
            }
        }
        throw new IllegalStateException("Unknown select strategy " + (Object)((Object)this.strategy));
    }

    public Performable from(By ... locators) {
        switch (this.strategy) {
            case ByValue: {
                return new SelectByValueFromBy(Arrays.asList(this.values), locators);
            }
            case ByVisibleText: {
                return new SelectByVisibleTextFromBy(Arrays.asList(this.options), locators);
            }
            case ByIndex: {
                return new SelectByIndexFromBy(Arrays.asList(this.indexes), locators);
            }
        }
        throw new IllegalStateException("Unknown select strategy " + (Object)((Object)this.strategy));
    }
}

