/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import java.util.Set;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Task;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.thucydides.core.annotations.Step;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchToNewWindow
implements Task {
    private static final Logger log = LoggerFactory.getLogger(SwitchToNewWindow.class);

    SwitchToNewWindow() {
    }

    @Step(value="{0} switches to new window")
    public <T extends Actor> void performAs(T actor) {
        WebDriver driver = BrowseTheWeb.as(actor).getDriver();
        Set allHandles = driver.getWindowHandles();
        log.debug("open windows: " + allHandles.size());
        if (allHandles.size() < 2) {
            log.error("Not enough windows open!");
            return;
        }
        String firstHandle = driver.getWindowHandle();
        Dimension windowSize = driver.manage().window().getSize();
        log.debug("current window: " + driver.getTitle() + ", at: " + driver.getCurrentUrl());
        for (String handle : allHandles) {
            if (handle.equals(firstHandle)) continue;
            driver.switchTo().window(handle);
            break;
        }
        log.debug("new window: " + driver.getTitle() + ", at: " + driver.getCurrentUrl());
        if (!driver.manage().window().getSize().equals((Object)windowSize)) {
            log.warn("Window size does not match!");
            driver.manage().window().setSize(windowSize);
        }
    }
}

