/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Tasks;
import net.serenitybdd.screenplay.actions.SelectStrategy;
import net.serenitybdd.screenplay.actions.deselectactions.DeselectByIndexFromTarget;
import net.serenitybdd.screenplay.actions.deselectactions.DeselectByValueFromTarget;
import net.serenitybdd.screenplay.actions.deselectactions.DeselectByVisibleTextFromTarget;
import net.serenitybdd.screenplay.targets.Target;

public class DeselectFromOptions {
    private final SelectStrategy strategy;
    private String theText;
    private Integer indexValue;

    public DeselectFromOptions(SelectStrategy strategy) {
        this.strategy = strategy;
    }

    public static DeselectFromOptions byValue(String value) {
        DeselectFromOptions enterAction = new DeselectFromOptions(SelectStrategy.ByValue);
        enterAction.theText = value;
        return enterAction;
    }

    public static DeselectFromOptions byVisibleText(String value) {
        DeselectFromOptions enterAction = new DeselectFromOptions(SelectStrategy.ByVisibleText);
        enterAction.theText = value;
        return enterAction;
    }

    public static DeselectFromOptions byIndex(Integer indexValue) {
        DeselectFromOptions enterAction = new DeselectFromOptions(SelectStrategy.ByIndex);
        enterAction.indexValue = indexValue;
        return enterAction;
    }

    public Performable from(String cssOrXpathForElement) {
        return this.from(Target.the(cssOrXpathForElement).locatedBy(cssOrXpathForElement));
    }

    public Performable from(Target target) {
        switch (this.strategy) {
            case ByValue: {
                return Tasks.instrumented(DeselectByValueFromTarget.class, (Object[])new Object[]{target, this.theText});
            }
            case ByVisibleText: {
                return Tasks.instrumented(DeselectByVisibleTextFromTarget.class, (Object[])new Object[]{target, this.theText});
            }
            case ByIndex: {
                return Tasks.instrumented(DeselectByIndexFromTarget.class, (Object[])new Object[]{target, this.indexValue});
            }
        }
        throw new IllegalStateException("Unknown select strategy " + (Object)((Object)this.strategy));
    }
}

