/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.rest.questions;

import io.restassured.response.Response;
import java.util.List;
import java.util.function.Function;
import net.serenitybdd.rest.SerenityRest;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.annotations.Subject;
import net.serenitybdd.screenplay.rest.interactions.Get;
import net.serenitybdd.screenplay.rest.questions.RestQueryFunction;

@Subject(value="#name")
public class RestQuestion<T>
implements Question<T> {
    private final List<RestQueryFunction> queries;
    private final String endpoint;
    private final String name;
    private final Function<Response, T> result;

    public RestQuestion(String name, String endpoint, List<RestQueryFunction> queries, Function<Response, T> result) {
        this.name = name;
        this.endpoint = endpoint;
        this.queries = queries;
        this.result = result;
    }

    public String toString() {
        return this.name;
    }

    public T answeredBy(Actor actor) {
        actor.attemptsTo(new Performable[]{Get.resource(this.endpoint).with(this.queries)});
        return this.result.apply(SerenityRest.lastResponse());
    }
}

