/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.serenitybdd.model.collect.NewList;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.requirements.BaseRequirementsService;
import net.thucydides.model.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.model.requirements.PackageAnnotationBasedTagProvider;
import net.thucydides.model.requirements.ReleaseProvider;
import net.thucydides.model.requirements.RequirementAncestry;
import net.thucydides.model.requirements.RequirementsCollector;
import net.thucydides.model.requirements.RequirementsProvided;
import net.thucydides.model.requirements.RequirementsProviderService;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.RequirementsTagProvider;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.statistics.service.AnnotationBasedTagProvider;
import net.thucydides.model.statistics.service.FeatureStoryTagProvider;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSourceRequirementsService
extends BaseRequirementsService
implements RequirementsService {
    private List<RequirementsTagProvider> requirementsTagProviders;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTagProvider.class);
    private static final List<String> LOW_PRIORITY_PROVIDERS = NewList.of(FileSystemRequirementsTagProvider.class.getCanonicalName(), PackageAnnotationBasedTagProvider.class.getCanonicalName(), AnnotationBasedTagProvider.class.getCanonicalName(), FeatureStoryTagProvider.class.getCanonicalName());

    public MultiSourceRequirementsService() {
        super(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null || this.requirements.isEmpty()) {
            StopWatch stopWatch = StopWatch.createStarted();
            this.requirements = ((Stream)this.getRequirementsTagProviders().stream().parallel()).flatMap(RequirementsProvided::asStream).collect(RequirementsCollector.merging());
            stopWatch.split();
            LOGGER.debug("Requirements loaded in {}", (Object)stopWatch.formatSplitTime());
            RequirementAncestry.addParentsTo(this.requirements);
            this.indexRequirements();
            stopWatch.split();
            LOGGER.debug("Requirements loaded and indexed in {}", (Object)stopWatch.formatTime());
        }
        return this.requirements;
    }

    @Override
    public Optional<ReleaseProvider> getReleaseProvider() {
        List<RequirementsTagProvider> requirementsTagProviders = this.getRequirementsTagProviders();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (!(provider instanceof ReleaseProvider) || !((ReleaseProvider)((Object)provider)).isActive()) continue;
            return Optional.of((ReleaseProvider)((Object)provider));
        }
        return Optional.empty();
    }

    public List<RequirementsTagProvider> getRequirementsTagProviders() {
        if (this.requirementsTagProviders == null) {
            RequirementsProviderService requirementsProviderService = ModelInfrastructure.getRequirementsProviderService();
            this.requirementsTagProviders = this.reprioritizeProviders(this.active(requirementsProviderService.getRequirementsProviders()));
        }
        return this.requirementsTagProviders;
    }

    private List<RequirementsTagProvider> active(List<RequirementsTagProvider> requirementsProviders) {
        boolean useDirectoryBasedRequirements = EnvironmentSpecificConfiguration.from(this.environmentVariables).getBooleanProperty(ThucydidesSystemProperty.SERENITY_USE_REQUIREMENTS_DIRECTORIES, true);
        if (useDirectoryBasedRequirements) {
            return requirementsProviders;
        }
        ArrayList<RequirementsTagProvider> activeRequirementsProviders = new ArrayList<RequirementsTagProvider>();
        for (RequirementsTagProvider provider : requirementsProviders) {
            if (provider instanceof FileSystemRequirementsTagProvider) continue;
            activeRequirementsProviders.add(provider);
        }
        return activeRequirementsProviders;
    }

    private List<RequirementsTagProvider> reprioritizeProviders(List<RequirementsTagProvider> requirementsTagProviders) {
        HashMap<String, RequirementsTagProvider> lowPriorityProviders = new HashMap<String, RequirementsTagProvider>();
        ArrayList<RequirementsTagProvider> prioritizedProviders = new ArrayList<RequirementsTagProvider>();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (LOW_PRIORITY_PROVIDERS.contains(provider.getClass().getCanonicalName())) {
                lowPriorityProviders.put(provider.getClass().getCanonicalName(), provider);
                continue;
            }
            prioritizedProviders.add(provider);
        }
        this.addLowPriorityProviders(lowPriorityProviders, prioritizedProviders);
        return prioritizedProviders;
    }

    private void addLowPriorityProviders(Map<String, RequirementsTagProvider> lowPriorityProviders, List<RequirementsTagProvider> prioritizedProviders) {
        for (String lowPriorityProvider : LOW_PRIORITY_PROVIDERS) {
            if (!lowPriorityProviders.containsKey(lowPriorityProvider)) continue;
            prioritizedProviders.add(lowPriorityProviders.get(lowPriorityProvider));
        }
    }

    @Override
    public void addRequirementTagsTo(TestOutcome outcome) {
        this.getRequirementsTagProviders().forEach(provider -> provider.addRequirementTagsTo(outcome));
    }
}

