/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.thucydides.model.requirements.model.Requirement;

public class AllRequirements {
    public static Stream<Requirement> asStreamFrom(List<Requirement> requirements) {
        if (requirements == null) {
            return Stream.of(new Requirement[0]);
        }
        return requirements.stream().flatMap(Requirement::stream);
    }

    public static List<Requirement> in(List<Requirement> requirements) {
        if (requirements == null) {
            return new ArrayList<Requirement>();
        }
        ArrayList<Requirement> allRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : requirements) {
            allRequirements.add(requirement);
            allRequirements.addAll(AllRequirements.childRequirementsOf(requirement));
        }
        return allRequirements;
    }

    private static Collection<Requirement> childRequirementsOf(Requirement requirement) {
        ArrayList<Requirement> childRequirements = new ArrayList<Requirement>();
        requirement.getChildrenAsStream().forEach(childRequirement -> {
            childRequirements.add((Requirement)childRequirement);
            childRequirements.addAll(AllRequirements.childRequirementsOf(childRequirement));
        });
        return childRequirements;
    }
}

