/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.html;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.thucydides.model.domain.TestResult;

public class ResultIconFormatter {
    private final Map<TestResult, String> resultIcons = new HashMap<TestResult, String>();
    private final Map<TestResult, String> resultIconStyles;
    private String qualifier;

    public ResultIconFormatter() {
        this.resultIcons.put(TestResult.COMPROMISED, "<a href='${report}#beforetable'><i class='bi bi-slash-circle-fill ${iconStyle} ${qualifier}' title='${result}'></i></a>");
        this.resultIcons.put(TestResult.ERROR, "<a href='${report}#beforetable'><i class='bi bi-exclamation-triangle-fill ${iconStyle} ${qualifier}' title='${result}'></i></a>");
        this.resultIcons.put(TestResult.FAILURE, "<a href='${report}#beforetable'><i class='bi bi-x-circle-fill ${iconStyle} ${qualifier}' title='${result}'></i></a>");
        this.resultIcons.put(TestResult.SUCCESS, "<a href='${report}#beforetable'><i class='bi bi-check-circle-fill ${iconStyle} ${qualifier}' title='${result}'></i></a>");
        this.resultIcons.put(TestResult.PENDING, "<a href='${report}#beforetable'><i class='bi bi-hourglass-top ${iconStyle} ${qualifier}' title='${result}'></i></a>");
        this.resultIcons.put(TestResult.ABORTED, "<a href='${report}#beforetable'><i class='bi bi-exclamation-octagon-fill ${iconStyle} ${qualifier}' title='${result}'></i></a>");
        this.resultIcons.put(TestResult.IGNORED, "<a href='${report}#beforetable'><i class='bi bi-slash-circle ${iconStyle} ${qualifier}' title='${result}'></i></a>");
        this.resultIcons.put(TestResult.SKIPPED, "<a href='${report}#beforetable'><i class='bi bi-skip-forward ${iconStyle} ${qualifier}' title='${result}'></i></a>");
        this.resultIcons.put(TestResult.UNDEFINED, "<i class='bi bi-pause-circle ${iconStyle} ${qualifier}' title='No test has been implemented yet'></i>");
        this.resultIconStyles = new HashMap<TestResult, String>();
        this.resultIconStyles.put(TestResult.COMPROMISED, "compromised-icon");
        this.resultIconStyles.put(TestResult.ERROR, "error-icon");
        this.resultIconStyles.put(TestResult.FAILURE, "failure-icon");
        this.resultIconStyles.put(TestResult.SUCCESS, "success-icon");
        this.resultIconStyles.put(TestResult.PENDING, "pending-icon");
        this.resultIconStyles.put(TestResult.ABORTED, "aborted-icon");
        this.resultIconStyles.put(TestResult.IGNORED, "ignored-icon");
        this.resultIconStyles.put(TestResult.SKIPPED, "skipped-icon");
        this.resultIconStyles.put(TestResult.UNDEFINED, "undefined-icon");
        this.qualifier = "";
    }

    public ResultIconFormatter inLarge() {
        this.qualifier = "fa-2x";
        return this;
    }

    public ResultIconFormatter inExtraLarge() {
        this.qualifier = "fa-3x";
        return this;
    }

    public String forResult(String result) {
        return this.forResult(TestResult.valueOf(result), "#");
    }

    public String forResult(TestResult result) {
        return this.forResult(result, "#");
    }

    public String forResult(TestResult result, String htmlReport) {
        TestResult testResult = Optional.ofNullable(result).orElse(TestResult.PENDING);
        return this.resultIcons.get((Object)testResult).replace("${report}", htmlReport).replace("${iconStyle}", this.resultIconStyles.get((Object)testResult)).replace("${qualifier}", this.qualifier).replace("${result}", testResult.toString());
    }

    public String colorFor(TestResult result) {
        return this.resultIconStyles.get((Object)Optional.ofNullable(result).orElse(TestResult.PENDING));
    }
}

