/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.html;

import io.cucumber.tagexpressions.Expression;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.reports.html.CucumberCompatibleFilter;
import net.thucydides.model.reports.html.CucumberTagConverter;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.util.EnvironmentVariables;

public class RequirementsFilter
extends CucumberCompatibleFilter {
    public RequirementsFilter(EnvironmentVariables environmentVariables) {
        super(environmentVariables);
    }

    public boolean inDisplayOnlyTags(Requirement requirement) {
        if (!this.tagsAreConfigured()) {
            return true;
        }
        Expression expectedTags = this.cucumberTagExpressionUsing(ThucydidesSystemProperty.TAGS);
        return this.requirementMatchesAnyTagIn(requirement, expectedTags);
    }

    private boolean tagsAreConfigured() {
        return !ThucydidesSystemProperty.TAGS.from(this.environmentVariables, "").isEmpty();
    }

    private boolean requirementMatchesAnyTagIn(Requirement requirement, Expression expectedTags) {
        if (new RequirementTagMatcher(expectedTags).test(requirement)) {
            return true;
        }
        return this.hasChildWithMatchingTag(requirement, expectedTags);
    }

    private boolean matchExistsInScenarios(Expression expectedTags, Requirement requirement) {
        return requirement.getScenarioTags().values().stream().map(CucumberTagConverter::toStrings).anyMatch(arg_0 -> ((Expression)expectedTags).evaluate(arg_0));
    }

    private boolean hasChildWithMatchingTag(Requirement requirement, Expression expectedTags) {
        if (!requirement.hasChildren()) {
            return false;
        }
        return requirement.getNestedChildren().stream().anyMatch(new RequirementTagMatcher(expectedTags));
    }

    public List<Requirement> filteredByDisplayTag(List<Requirement> requirements) {
        return requirements.stream().filter(this::inDisplayOnlyTags).map(this::withFilteredChildren).collect(Collectors.toList());
    }

    private Requirement withFilteredChildren(Requirement requirement) {
        if (!requirement.hasChildren()) {
            return requirement;
        }
        return requirement.withChildren(this.filteredByDisplayTag(requirement.getChildren()));
    }

    private class RequirementTagMatcher
    implements Predicate<Requirement> {
        private Expression expectedTags;

        public RequirementTagMatcher(Expression expectedTags) {
            this.expectedTags = expectedTags;
        }

        @Override
        public boolean test(Requirement requirement) {
            return this.expectedTags.evaluate(CucumberTagConverter.toStrings(requirement.getTags())) || RequirementsFilter.this.matchExistsInScenarios(this.expectedTags, requirement);
        }
    }
}

