/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.model.webdriver.Configuration;

public class Downloadables {
    public static String copyDownloadableFileFrom(Path source) throws IOException {
        Configuration configuration = ConfiguredEnvironment.getConfiguration();
        File outputDirectory = configuration.getOutputDirectory();
        Path downloadDirectory = outputDirectory.toPath().resolve("downloadable");
        Files.createDirectories(downloadDirectory, new FileAttribute[0]);
        Path relativePath = Downloadables.downloadableCopyOf(source);
        Path downloadablePath = outputDirectory.toPath().resolve(relativePath);
        Files.copy(source, downloadablePath, StandardCopyOption.REPLACE_EXISTING);
        return relativePath.toString();
    }

    private static Path downloadableCopyOf(Path path) {
        return Paths.get("downloadable", "downloadable-" + String.valueOf(UUID.randomUUID()) + "-" + path.getFileName().toString());
    }
}

