/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;

public class FeatureFilePath {
    private final String featureFolder;
    private static String FEATURE_FILES_DIRECTORY = "src/test/resources/[^/]+/";
    private static final Pattern FEATURE_FILES_DIRECTORY_PATTERN = Pattern.compile(FEATURE_FILES_DIRECTORY);

    public FeatureFilePath(EnvironmentVariables environmentVariables) {
        this.featureFolder = EnvironmentSpecificConfiguration.from(environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_FEATURES_DIRECTORY).orElse("features");
    }

    public String relativePathFor(String path) {
        int lastFeatures = path.lastIndexOf("/" + this.featureFolder + "/");
        if (lastFeatures >= 0) {
            return path.substring(lastFeatures + this.featureFolder.length() + 2);
        }
        return this.relativeFeaturePath(path);
    }

    private String relativeFeaturePath(String path) {
        String normalisedPath = path;
        Matcher matcher = FEATURE_FILES_DIRECTORY_PATTERN.matcher(path);
        if (matcher.find()) {
            normalisedPath = path.substring(matcher.end());
        }
        return normalisedPath;
    }
}

