/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.issues;

import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class SystemPropertiesIssueTracking
implements IssueTracking {
    private EnvironmentVariables environmentVariables;

    public SystemPropertiesIssueTracking() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public SystemPropertiesIssueTracking(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String getIssueTrackerUrl() {
        if (this.jiraUrlDefined()) {
            return ThucydidesSystemProperty.JIRA_URL.from(this.environmentVariables) + "/browse/{0}";
        }
        return ThucydidesSystemProperty.SERENITY_ISSUE_TRACKER_URL.from(this.environmentVariables);
    }

    @Override
    public String getShortenedIssueTrackerUrl() {
        if (this.jiraUrlDefined()) {
            return ThucydidesSystemProperty.JIRA_URL.from(this.environmentVariables) + "/browse/" + this.getJiraProjectSuffix() + "{0}";
        }
        return ThucydidesSystemProperty.SERENITY_ISSUE_TRACKER_URL.from(this.environmentVariables);
    }

    private String getJiraProjectSuffix() {
        if (this.jiraProjectDefined()) {
            return ThucydidesSystemProperty.JIRA_PROJECT.from(this.environmentVariables) + "-";
        }
        return "";
    }

    private boolean jiraUrlDefined() {
        return !StringUtils.isEmpty((CharSequence)ThucydidesSystemProperty.JIRA_URL.from(this.environmentVariables));
    }

    private boolean jiraProjectDefined() {
        return !StringUtils.isEmpty((CharSequence)ThucydidesSystemProperty.JIRA_PROJECT.from(this.environmentVariables));
    }
}

