/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.configuration;

import java.io.File;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.configuration.BuildDirectoryProvider;

class MavenBuildDirectory {
    MavenBuildDirectory() {
    }

    static BuildDirectoryProvider forAMavenProject() {
        return new BuildDirectoryProvider(){

            @Override
            public String buildDirectoryFrom(String baseDirectory) {
                return Joiner.on(File.separator).join(baseDirectory, "target", "site", "serenity");
            }
        };
    }

    static BuildDirectoryProvider forAMavenProjectWithAConfiguredReportDirectoryTarget() {
        return new BuildDirectoryProvider(){

            @Override
            public String buildDirectoryFrom(String baseDirectory) {
                return Joiner.on(File.separator).join(baseDirectory, "serenity");
            }
        };
    }

    static BuildDirectoryProvider forAMavenProjectWithAConfiguredReportDirectory() {
        return new BuildDirectoryProvider(){

            @Override
            public String buildDirectoryFrom(String baseDirectory) {
                return baseDirectory;
            }
        };
    }

    static BuildDirectoryProvider forADefaultMavenConfiguration() {
        return new BuildDirectoryProvider(){

            @Override
            public String buildDirectoryFrom(String baseDirectory) {
                return Joiner.on(File.separator).join("target", "site", "serenity");
            }
        };
    }
}

