/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ThucydidesSystemProperty {
    WEBDRIVER_DRIVER,
    DRIVER,
    WEBDRIVER_CAPABILITIES_BROWSERNAME("webdriver.capabilities.browserName"),
    WEBDRIVER_PROVIDED_TYPE,
    WEBDRIVER_BASE_URL,
    WEBDRIVER_REMOTE_URL,
    USE_CHROME_AUTOMATION_OPTIONS,
    WEBDRIVER_AUTODOWNLOAD,
    WEBDRIVER_RETRY_ON_STALE_ELEMENT_EXCEPTION,
    WEBDRIVER_REMOTE_DRIVER,
    WEBDRIVER_REMOTE_BROWSER_VERSION,
    WEBDRIVER_REMOTE_OS,
    WEBDRIVER_MIN_SCREENSHOT_INTERVAL,
    WEBDRIVER_IE_DRIVER,
    WEBDRIVER_EDGE_DRIVER,
    WEBDRIVER_CHROME_DRIVER,
    WEBDRIVER_CHROME_BINARY,
    CHROME_BINARY,
    THUCYDIDES_PROJECT_KEY,
    SERENITY_PROJECT_KEY,
    THUCYDIDES_PROJECT_NAME,
    SERENITY_PROJECT_NAME,
    SERENITY_SUMMARY_REPORT_TITLE,
    SERENITY_SUMMARY_REPORT_FILENAME,
    REPORT_SUBTITLE,
    REPORT_TIMEOUT_THREADDUMPS,
    SERENITY_REPORT_URL,
    THUCYDIDES_HOME,
    SERENITY_HOME,
    THUCYDIDES_REPORT_RESOURCES,
    SERENITY_REPORT_RESOURCES,
    THUCYDIDES_REPORT_ENCODING,
    SERENITY_REPORT_ENCODING,
    REMOTE_PLATFORM,
    THUCYDIDES_OUTPUT_DIRECTORY("thucydides.outputDirectory"),
    SERENITY_OUTPUT_DIRECTORY("serenity.outputDirectory"),
    THUCYDIDES_CONFIGURATION_REPORT("thucydides.configuration.json"),
    SERENITY_CONFIGURATION_REPORT("serenity.configuration.json"),
    THUCYDIDES_FLOW_REPORTS_DIR("flow"),
    SERENITY_FLOW_REPORTS_DIR("flow"),
    THUCYDIDES_ONLY_SAVE_FAILING_SCREENSHOTS,
    THUCYDIDES_DRIVER_CAPABILITIES,
    SERENITY_DRIVER_CAPABILITIES,
    THUCYDIDES_VERBOSE_SCREENSHOTS,
    THUCYDIDES_VERBOSE_STEPS,
    SERENITY_VERBOSE_STEPS,
    VERBOSE_REPORTING,
    SCREENPLAY_PRONOUNS,
    THUCYDIDES_TAKE_SCREENSHOTS,
    SERENITY_TAKE_SCREENSHOTS,
    THUCYDIDES_REPORTS_SHOW_STEP_DETAILS,
    SERENITY_REPORTS_SHOW_STEP_DETAILS,
    THUCYDIDES_REPORT_SHOW_MANUAL_TESTS,
    SERENITY_REPORT_SHOW_MANUAL_TESTS,
    SERENITY_REPORT_EXCLUDE_TAGS,
    HIDDEN_TAGS,
    THUCYDIDES_REPORT_SHOW_RELEASES,
    SERENITY_REPORT_SHOW_RELEASES,
    SERENITY_REPORT_ACCESSIBILITY,
    SERENITY_REPORT_DURATIONS,
    THUCYDIDES_REPORT_SHOW_PROGRESS,
    SERENITY_REPORT_SHOW_PROGRESS,
    THUCYDIDES_REPORT_SHOW_HISTORY,
    SERENITY_REPORT_SHOW_HISTORY,
    THUCYDIDES_REPORT_SHOW_TAG_MENUS,
    SERENITY_REPORT_SHOW_TAG_MENUS,
    THUCYDIDES_REPORT_TAG_MENUS,
    SERENITY_REPORT_TAG_MENUS,
    THUCYDIDES_EXCLUDE_UNRELATED_REQUIREMENTS_OF_TYPE,
    SERENITY_EXCLUDE_UNRELATED_REQUIREMENTS_OF_TYPE,
    THUCYDIDES_RESTART_BROWSER_FREQUENCY,
    SERENITY_REPORT_HIDE_EMPTY_REQUIREMENTS,
    SERENITY_RESTART_BROWSER_FREQUENCY,
    THUCYDIDES_RESTART_BROWSER_FOR_EACH,
    SERENITY_RESTART_BROWSER_FOR_EACH,
    THUCYDIDES_DIFFERENT_BROWSER_FOR_EACH_ACTOR,
    SERENITY_DIFFERENT_BROWSER_FOR_EACH_ACTOR,
    THUCYDIDES_STEP_DELAY,
    SERENITY_STEP_DELAY,
    THUCYDIDES_TIMEOUT,
    SERENITY_TIMEOUT,
    REFUSE_UNTRUSTED_CERTIFICATES,
    THUCYDIDES_USE_UNIQUE_BROWSER,
    THUCYDIDES_ESTIMATED_AVERAGE_STEP_COUNT,
    SERENITY_ESTIMATED_AVERAGE_STEP_COUNT,
    THUCYDIDES_ESTIMATED_TESTS_PER_REQUIREMENT,
    SERENITY_ESTIMATED_TESTS_PER_REQUIREMENT,
    THUCYDIDES_ISSUE_TRACKER_URL,
    SERENITY_ISSUE_TRACKER_URL,
    THUCYDIDES_NATIVE_EVENTS,
    SERENITY_NATIVE_EVENTS,
    JIRA_URL,
    JIRA_PROJECT,
    JIRA_USERNAME,
    JIRA_PASSWORD,
    SERENITY_JIRA_WORKFLOW,
    SERENITY_JIRA_WORKFLOW_ACTIVE,
    THUCYDIDES_HISTORY,
    SERENITY_HISTORY,
    THUCYDIDES_BROWSER_HEIGHT,
    SERENITY_BROWSER_HEIGHT,
    THUCYDIDES_BROWSER_WIDTH,
    SERENITY_BROWSER_WIDTH,
    THUCYDIDES_BROWSER_MAXIMIZED,
    SERENITY_BROWSER_MAXIMIZED,
    SERENITY_BROWSER_FULL_SCREEN,
    THUCYDIDES_RESIZED_IMAGE_WIDTH,
    SERENITY_BROWSER_RESIZING,
    SERENITY_RESIZED_IMAGE_WIDTH,
    THUCYDIDES_PUBLIC_URL,
    SERENITY_PUBLIC_URL,
    THUCYDIDES_ACTIVATE_FIREBUGS,
    SERENITY_ACTIVATE_FIREBUGS,
    SECURITY_ENABLE_JAVA("security.enable_java"),
    THUCYDIDES_ACTIVATE_HIGHLIGHTING,
    SERENITY_ACTIVATE_HIGHLIGHTING,
    THUCYDIDES_BATCH_STRATEGY,
    SERENITY_BATCH_STRATEGY,
    THUCYDIDES_BATCH_COUNT,
    SERENITY_BATCH_COUNT,
    THUCYDIDES_BATCH_SIZE,
    SERENITY_BATCH_SIZE,
    THUCYDIDES_BATCH_NUMBER,
    SERENITY_BATCH_NUMBER,
    THUCYDIDES_PROXY_HTTP,
    THUCYDIDES_PROXY_HTTP_PORT("thucydides.proxy.http_port"),
    THUCYDIDES_PROXY_TYPE,
    THUCYDIDES_PROXY_USER,
    THUCYDIDES_PROXY_PASSWORD,
    SERENITY_PROXY_HTTP,
    SERENITY_PROXY_HTTP_PORT("serenity.proxy.http_port"),
    SERENITY_PROXY_USER,
    SERENITY_PROXY_PASSWORD,
    SERENITY_PROXY_SSL_PORT("serenity.proxy.sslProxyPort"),
    SERENITY_PROXY_SSL("serenity.proxy.sslProxy"),
    SERENITY_PROXY_FTP,
    SERENITY_PROXY_AUTODETECT,
    SERENITY_PROXY_NOPROXY,
    SERENITY_PROXY_TYPE,
    SERENITY_PROXY_AUTOCONFIG,
    SERENITY_PROXY_SOCKS_PROXY,
    SERENITY_PROXY_SOCKS_USERNAME,
    SERENITY_PROXY_SOCKS_PASSWORD,
    SERENITY_PROXY_SOCKS_VERSION,
    SERENITY_DRIVER_PAGE_LOAD_STRATEGY,
    SERENITY_DRIVER_UNEXPECTED_ALERT_BEHAVIOUR,
    WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT,
    WEBDRIVER_TIMEOUTS_FLUENTWAIT,
    WEBDRIVER_WAIT_FOR_TIMEOUT,
    THUCYDIDES_EXT_PACKAGES,
    SERENITY_EXT_PACKAGES,
    CHROME_SWITCHES,
    CHROME_EXTENSION,
    CHROME_DEFAULT_OPTIONS_W3C,
    FIREFOX_PREFERENCES,
    DRIVER_OPTIONS,
    WEBDRIVER_USE_DRIVER_SERVICE_POOL,
    WEBDRIVER_FIREFOX_PROFILE,
    THUCYDIDES_JQUERY_INTEGRATION,
    SERENITY_JQUERY_INTEGRATION,
    SAUCELABS_BROWSERNAME("saucelabs.browserName"),
    SAUCELABS_TARGET_PLATFORM,
    SAUCELABS_BROWSER_VERSION,
    SAUCELABS_TEST_NAME,
    SAUCELABS_DATACENTER,
    SAUCELABS_URL,
    SAUCELABS_ACCESS_KEY("saucelabs.accessKey"),
    SAUCELABS_USER_ID("saucelabs.username"),
    SAUCELABS_IMPLICIT_TIMEOUT,
    SAUCELABS_RECORD_SCREENSHOTS,
    BROWSERSTACK_URL,
    BROWSERSTACK_USER,
    BROWSERSTACK_KEY,
    BROWSERSTACK_OS,
    BROWSERSTACK_OS_VERSION("browserstack.os_version"),
    BROWSERSTACK_BROWSER,
    BROWSERSTACK_BROWSERNAME("browserstack.browserName"),
    BROWSERSTACK_BROWSER_VERSION,
    BROWSERSTACK_DEVICE,
    BROWSERSTACK_DEVICE_ORIENTATION,
    BROWSERSTACK_PROJECT,
    BROWSERSTACK_BUILD,
    BROWSERSTACK_SESSION_NAME,
    BROWSERSTACK_LOCAL,
    BROWSERSTACK_DEBUG,
    BROWSERSTACK_RESOLUTION,
    BROWSERSTACK_SELENIUM_VERSION,
    BROWSERSTACK_IE_NO_FLASH,
    BROWSERSTACK_IE_DRIVER,
    BROWSERSTACK_IE_ENABLE_POPUPS,
    THUCYDIDES_FILE_IO_RETRY_TIMEOUT,
    SERENITY_FILE_IO_RETRY_TIMEOUT,
    THUCYDIDES_LOGGING,
    SERENITY_LOGGING,
    THUCYDIDES_TEST_ROOT,
    SERENITY_TEST_ROOT,
    CURRENT_TARGET_VERSION,
    THUCYDIDES_REQUIREMENTS_DIR,
    SERENITY_REQUIREMENTS_DIR,
    SERENITY_TEST_STATISTICS_DIR,
    THUCYDIDES_USE_REQUIREMENTS_DIRECTORIES,
    SERENITY_FEATURES_DIRECTORY,
    SERENITY_SHOW_STORY_DETAILS_IN_TESTS,
    SERENITY_STORIES_DIRECTORY,
    SERENITY_DISABLE_REST_CALLS_AFTER_FAILURES,
    SERENITY_USE_REQUIREMENTS_DIRECTORIES,
    THUCYDIDES_ANNOTATED_REQUIREMENTS_DIR,
    SERENITY_ANNOTATED_REQUIREMENTS_DIR,
    THUCYDIDES_LOWEST_REQUIREMENT_TYPE,
    SERENITY_LOWEST_REQUIREMENT_TYPE,
    THUCYDIDES_REQUIREMENT_TYPES,
    SERENITY_REQUIREMENT_TYPES,
    THUCYDIDES_REQUIREMENT_EXCLUSIONS,
    SERENITY_REQUIREMENT_EXCLUSIONS,
    THUCYDIDES_RELEASE_TYPES,
    SERENITY_RELEASE_TYPES,
    THUCYDIDES_LOCATOR_FACTORY,
    SERENITY_LOCATOR_FACTORY,
    THUCYDIDES_DATA_DIR,
    SERENITY_DATA_DIR,
    PROPERTIES,
    THUCYDIDES_TEST_REQUIREMENTS_BASEDIR,
    SERENITY_TEST_REQUIREMENTS_BASEDIR,
    SERENITY_STORE_HTML,
    THUCYDIDES_KEEP_UNSCALED_SCREENSHOTS,
    SERENITY_KEEP_UNSCALED_SCREENSHOTS,
    TAGS,
    INJECTED_TAGS,
    THUCYDIDES_CSV_EXTRA_COLUMNS,
    SHOW_HISTORY_FLAGS,
    SERENITY_HISTORY_DIRECTORY("serenity.historyDirectory"),
    DELETE_HISTORY_DIRECTORY,
    SERENITY_GENERATE_CSV_REPORTS,
    SERENITY_CSV_EXTRA_COLUMNS,
    THUCYDIDES_CONSOLE_HEADINGS,
    SERENITY_CONSOLE_BANNER,
    SERENITY_CONSOLE_HEADINGS,
    THUCYDIDES_CONSOLE_COLORS,
    SERENITY_CONSOLE_COLORS,
    SERENITY_DISPLAY_TEST_NUMBERS,
    NARRATIVE_FORMAT,
    OUTPUT_FORMATS,
    ENABLE_MARKDOWN,
    WEBDRIVER_GECKO_DRIVER,
    IGNORE_EMBEDDED_TABLES,
    SHOW_RELATED_TAGS,
    USE_TEST_CASE_FOR_STORY_TAG,
    SHOW_PIE_CHARTS,
    DASHBOARD_TAG_LIST,
    SERENITY_COMPRESS_FILENAMES,
    SERENITY_COMPRESS_SCREENSHOTS,
    SERENITY_SCREENSHOOTER,
    SERENITY_FULL_PAGE_SCREENSHOT_STRATEGY,
    SERENITY_SCREENSHOT_STRATEGY,
    DASHBOARD_EXCLUDED_TAG_LIST,
    REPORT_RAW_TAG_LIST,
    JSON_PRETTY_PRINTING,
    JSON_CHARSET,
    REPORT_CHARSET,
    SIMPLIFIED_STACK_TRACES,
    THUCYDIDES_DRY_RUN,
    SERENITY_DRY_RUN,
    FEATURE_FILE_LANGUAGE,
    THUCYDIDES_DISPLAY_CONTEXT,
    SERENITY_ADD_CONTEXT_TAG,
    FEATURE_FILE_ENCODING,
    REPORT_THREADS,
    REPORT_MAX_THREADS,
    REPORT_KEEP_ALIVE_TIME,
    DEEP_STEP_EXECUTION_AFTER_FAILURES,
    MANUAL_TEST_REPORT_RESULT,
    THUCYDIDES_MAINTAIN_SESSION,
    SERENITY_MAINTAIN_SESSION,
    SERENITY_COMPROMISED_ON,
    SERENITY_SKIPPED_ON,
    SERENITY_ERROR_ON,
    SERENITY_FAIL_ON,
    SERENITY_FORK_COUNT,
    SERENITY_FORK_NUMBER,
    SERENITY_PENDING_ON,
    SERENITY_TAG_FAILURES,
    SERENITY_LINKED_TAGS,
    SERENITY_WEBDRIVER_COLLECTION_LOADING_STRATEGY("serenity.webdriver.collection_loading_strategy"),
    USE_GECKO_DRIVER,
    GECKO_FIREFOX_OPTIONS,
    FIREFOX_OPTIONS,
    TEST_RETRY_COUNT,
    TEST_RETRY_COUNT_CUCUMBER,
    RECORD_FAILURES,
    REPLAY_FAILURES,
    RERUN_FAILURES_DIRECTORY,
    CONTEXT,
    APPIUM_HUB,
    STEP_CREATION_STRATEGY,
    SAFARI_USE_CLEAN_SESSION,
    HEADLESS_MODE,
    REPORT_ASSETS_DIRECTORY,
    FIREFOX_LOG_LEVEL,
    APPIUM_UDID("appium.udid"),
    APPIUM_DEVICE_NAME("appium.deviceName"),
    APPIUM_PLATFORMNAME("appium.platformName"),
    APPIUM_DEVICE_NAMES("appium.deviceNames"),
    MANAGE_APPIUM_SERVERS,
    APPIUM_ADDITIONAL_CAPABILITIES("appium.additional.capabilities"),
    APPIUM_PROCESS_DESIRED_CAPABILITIES("appium.process.desired.capabilities"),
    ACCEPT_INSECURE_CERTIFICATES,
    FIREFOX_PREFERENCE_SEPARATOR,
    SERENITY_WEBDRIVER_INTEGRATION,
    SERENITY_MAXIMUM_STEP_NESTING_DEPTH,
    REPORT_SCOREBOARD_SIZE,
    SHOW_FULL_TEST_RESULTS,
    REPORT_TAGTYPES,
    SERENITY_REPORT_TAGTYPES,
    MAX_FREQUENT_FAILURES,
    CUCUMBER_PRETTY_FORMAT_TABLES,
    IO_BLOCKING_COEFFICIENT,
    MANUAL_RESULT_EXPIRY_LIMIT,
    MANUAL_TASK_INSTRUMENTATION,
    SERENITY_EXTENSION_PACKAGES,
    WEBDRIVER_CREATION_RETRY_CAUSES,
    WEBDRIVER_CREATION_RETRY_MAX_TIME,
    SERENITY_INCLUDE_ACTOR_NAME_IN_CONSEQUENCES,
    LEGACY_WAIT_FOR_TEXT,
    ENVIRONMENT,
    SERENITY_ENABLE_WEBDRIVER_IN_FIXTURE_METHODS,
    EDGE_OPTIONS,
    IE_OPTIONS_ENABLE_NATIVE_EVENTS("ieOptions.EnableNativeEvents"),
    IE_OPTIONS_IGNORE_ZOOM_LEVEL("ieOptions.IgnoreZoomLevel"),
    IE_OPTIONS_REQUIRE_WINDOW_FOCUS("ieOptions.RequireWindowFocus"),
    REPORT_TAGTYPE_TITLE,
    SERENITY_REQUIREMENTS_CACHE_HEAP_SIZE,
    WEBDRIVER_WAIT_FOR_ALERT_TIMEOUT("webdriver.wait.for.alert.timeout");

    private String propertyName;
    public static final int DEFAULT_HEIGHT = 700;
    public static final int DEFAULT_WIDTH = 960;
    public static final String DEFAULT_HISTORY_DIRECTORY = "history";
    private final Logger logger = LoggerFactory.getLogger(ThucydidesSystemProperty.class);

    private ThucydidesSystemProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    private ThucydidesSystemProperty() {
        this.propertyName = this.name().replace("_", ".").toLowerCase();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getLegacyPropertyName() {
        if (this.propertyName.startsWith("serenity.")) {
            return "thucydides." + this.propertyName.substring(9);
        }
        return this.propertyName;
    }

    public String toString() {
        return this.propertyName;
    }

    public Optional<String> optionalFrom(EnvironmentVariables environmentVariables) {
        return Optional.ofNullable(this.from(environmentVariables, null));
    }

    public String from(EnvironmentVariables environmentVariables) {
        return this.from(environmentVariables, null);
    }

    private Optional<String> legacyPropertyValueIfPresentIn(EnvironmentVariables environmentVariables) {
        String legacyValue = environmentVariables.getProperty(this.withLegacyPrefix(this.getPropertyName()));
        if (StringUtils.isNotEmpty((CharSequence)legacyValue)) {
            this.logger.warn("Legacy property format detected for {}, please use the serenity.* format instead.", (Object)this.getPropertyName());
        }
        return Optional.ofNullable(legacyValue);
    }

    private String withLegacyPrefix(String propertyName) {
        return propertyName.replace("serenity.", "thucydides.");
    }

    private String withSerenityPrefix(String propertyName) {
        return propertyName.replace("thucydides.", "serenity.");
    }

    public String preferredName() {
        return this.withSerenityPrefix(this.getPropertyName());
    }

    public List<String> legacyNames() {
        ArrayList<String> names = new ArrayList<String>(1);
        names.add(this.withLegacyPrefix(this.getPropertyName()));
        return names;
    }

    public String from(EnvironmentVariables environmentVariables, String defaultValue) {
        Optional<String> newPropertyValue = this.optionalPropertyValueDefinedIn(environmentVariables);
        if (this.isDefined(newPropertyValue)) {
            return newPropertyValue.get();
        }
        Optional<String> legacyValue = this.legacyPropertyValueIfPresentIn(environmentVariables);
        return this.isDefined(legacyValue) ? legacyValue.get() : defaultValue;
    }

    private boolean isDefined(Optional<String> newPropertyValue) {
        return newPropertyValue.isPresent() && StringUtils.isNotEmpty((CharSequence)newPropertyValue.get());
    }

    public int integerFrom(EnvironmentVariables environmentVariables) {
        return this.integerFrom(environmentVariables, 0);
    }

    public int integerFrom(EnvironmentVariables environmentVariables, int defaultValue) {
        Optional<String> newPropertyValue = this.optionalPropertyValueDefinedIn(environmentVariables);
        if (this.isDefined(newPropertyValue)) {
            return Integer.parseInt(newPropertyValue.get().trim());
        }
        Optional<String> legacyValue = this.legacyPropertyValueIfPresentIn(environmentVariables);
        return this.isDefined(legacyValue) ? Integer.parseInt(legacyValue.get().trim()) : defaultValue;
    }

    public long longFrom(EnvironmentVariables environmentVariables, long defaultValue) {
        Optional<String> newPropertyValue = this.optionalPropertyValueDefinedIn(environmentVariables);
        if (this.isDefined(newPropertyValue)) {
            return Integer.parseInt(newPropertyValue.get().trim());
        }
        Optional<String> legacyValue = this.legacyPropertyValueIfPresentIn(environmentVariables);
        return this.isDefined(legacyValue) ? (long)Integer.parseInt(legacyValue.get().trim()) : defaultValue;
    }

    public Boolean booleanFrom(EnvironmentVariables environmentVariables) {
        return this.booleanFrom(environmentVariables, false);
    }

    public Boolean booleanFrom(EnvironmentVariables environmentVariables, Boolean defaultValue) {
        if (environmentVariables == null) {
            return defaultValue;
        }
        Optional<String> newPropertyValue = this.optionalPropertyValueDefinedIn(environmentVariables);
        if (this.isDefined(newPropertyValue)) {
            return Boolean.valueOf(newPropertyValue.get().trim());
        }
        Optional<String> legacyValue = this.legacyPropertyValueIfPresentIn(environmentVariables);
        return this.isDefined(legacyValue) ? Boolean.valueOf(legacyValue.get().trim()) : defaultValue;
    }

    private Optional<String> optionalPropertyValueDefinedIn(EnvironmentVariables environmentVariables) {
        return EnvironmentSpecificConfiguration.from(environmentVariables).getOptionalProperty(this.withSerenityPrefix(this.getPropertyName()));
    }

    public boolean isDefinedIn(EnvironmentVariables environmentVariables) {
        return StringUtils.isNotEmpty((CharSequence)this.from(environmentVariables));
    }
}

