/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.buildinfo;

import com.google.common.base.Splitter;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.serenitybdd.core.buildinfo.BuildProperties;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.ModelInfrastructure;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfoProvider {
    private final EnvironmentVariables environmentVariables;
    private final DriverCapabilityRecord driverCapabilityRecord;
    private final Map<String, Map<String, String>> sections;
    private static final List<String> MASKABLE = Arrays.asList("accessKey", "key");
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildInfoProvider.class);
    private Binding binding;

    public BuildInfoProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.driverCapabilityRecord = ModelInfrastructure.getDriverCapabilityRecord();
        this.sections = new HashMap<String, Map<String, String>>();
    }

    public BuildProperties getBuildProperties() {
        HashMap<String, String> generalProperties = new HashMap<String, String>();
        generalProperties.put("Default Driver", ThucydidesSystemProperty.DRIVER.from(this.environmentVariables, "firefox"));
        generalProperties.put("Operating System", System.getProperty("os.name") + " version " + System.getProperty("os.version"));
        this.addGroupPropertiesTo("saucelabs", generalProperties);
        this.addGroupPropertiesTo("browserstack", generalProperties);
        this.driverCapabilityRecord.getDrivers().forEach(driver -> generalProperties.put("Driver " + driver, this.driverCapabilityRecord.getDriverCapabilities().get(driver).toString()));
        this.addCustomPropertiesTo(generalProperties);
        Map<String, Properties> driverPropertiesMap = this.driverCapabilityRecord.getDriverCapabilities();
        return new BuildProperties(generalProperties, this.driverCapabilityRecord.getDrivers(), driverPropertiesMap, this.sections);
    }

    private void addGroupPropertiesTo(String groupName, Map<String, String> buildProperties) {
        if (EnvironmentSpecificConfiguration.from(this.environmentVariables).propertyGroupIsDefinedFor(groupName)) {
            EnvironmentSpecificConfiguration.from(this.environmentVariables).getPropertiesWithPrefix(groupName).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                String ungroupedKey = key.toString().replace(groupName + ".", "");
                String sanitizedValue = this.sanitized(ungroupedKey, value.toString());
                buildProperties.put(StringUtils.capitalize((String)groupName) + " Property: " + ungroupedKey, this.sanitized(key.toString(), sanitizedValue));
            }));
        }
    }

    private String sanitized(String property, String value) {
        boolean isMaskable = MASKABLE.stream().anyMatch(maskableKey -> property.contains((CharSequence)maskableKey));
        if (isMaskable) {
            return value.contains("@") && value.contains(":") ? this.maskAPIKey(value) : this.maskedKey(value);
        }
        return isMaskable ? this.maskAPIKey(value) : value;
    }

    private String maskAPIKey(String url) {
        if (url == null) {
            return "";
        }
        if (url.contains("@")) {
            int apiKeyStart = url.indexOf(":");
            int apiKeyEnd = url.indexOf("@");
            return url.substring(0, apiKeyStart + 3) + "XXXXXXXXXXXXXXXX" + url.substring(apiKeyEnd);
        }
        return url;
    }

    private void addCustomPropertiesTo(Map<String, String> buildProperties) {
        Properties sysInfoProperties = EnvironmentSpecificConfiguration.from(this.environmentVariables).getPropertiesWithPrefix("sysinfo");
        sysInfoProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String resolvedValue;
            String simplifiedKey = key.toString().replace("sysinfo.", "");
            String expression = value.toString();
            String string = resolvedValue = this.isGroovyExpression(expression) ? this.evaluateGroovyExpression(key.toString(), expression) : expression;
            if (this.isInASection(simplifiedKey)) {
                String sectionKey = this.humanizedFormOf(this.sectionKeyFrom(simplifiedKey));
                String fieldKey = this.humanizedFormOf(this.sectionLabelFrom(simplifiedKey));
                Map sectionValues = this.sections.getOrDefault(sectionKey, new HashMap());
                sectionValues.put(fieldKey, resolvedValue);
                this.sections.put(sectionKey, sectionValues);
            } else {
                buildProperties.put(this.humanizedFormOf(simplifiedKey), resolvedValue);
            }
        }));
    }

    private String sectionKeyFrom(String simplifiedKey) {
        return (String)Splitter.on((String)".").splitToList((CharSequence)simplifiedKey).get(0);
    }

    private String sectionLabelFrom(String simplifiedKey) {
        return (String)Splitter.on((String)".").splitToList((CharSequence)simplifiedKey).get(1);
    }

    private boolean isInASection(String simplifiedKey) {
        return simplifiedKey.contains(".");
    }

    private boolean isGroovyExpression(String expression) {
        return expression.startsWith("${") && expression.endsWith("}");
    }

    private String humanizedFormOf(String simplifiedKey) {
        return StringUtils.strip((String)StringUtils.capitalize((String)StringUtils.replace((String)simplifiedKey, (String)".", (String)" ").replace("_", " ")), (String)"\"");
    }

    private Binding groovyBinding() {
        this.binding = new Binding();
        this.binding.setVariable("env", this.environmentVariables.asMap());
        return this.binding;
    }

    private String evaluateGroovyExpression(String key, String expression) {
        GroovyShell shell = new GroovyShell(this.groovyBinding());
        Object result = null;
        try {
            String groovy = expression.substring(2, expression.length() - 1);
            if (StringUtils.isNotEmpty((CharSequence)groovy)) {
                result = shell.evaluate(groovy);
            }
        }
        catch (GroovyRuntimeException e) {
            String error = String.format("Failed to evaluate build info expression '%s' for key '%s'", expression, key);
            LOGGER.warn(error);
        }
        return result != null ? result.toString() : expression;
    }

    private String maskedKey(String value) {
        return value.substring(0, 3) + "XXXXXXXXXXXXXXXX" + value.substring(value.length() - 3);
    }
}

