/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import org.apache.commons.lang3.StringUtils;

public class ParameterizedTestsOutcomeAggregator {
    private List<TestOutcome> allTestOutcomes;

    public ParameterizedTestsOutcomeAggregator() {
        BaseStepListener baseStepListener = StepEventBus.getEventBus().getBaseStepListener();
        this.allTestOutcomes = baseStepListener.getTestOutcomes();
    }

    public ParameterizedTestsOutcomeAggregator(BaseStepListener baseStepListener) {
        this.allTestOutcomes = baseStepListener.getTestOutcomes();
    }

    public ParameterizedTestsOutcomeAggregator(List<TestOutcome> testOutcomes) {
        this.allTestOutcomes = testOutcomes;
    }

    public List<TestOutcome> aggregateTestOutcomesByTestMethods() {
        List<TestOutcome> allOutcomes = this.getTestOutcomesForAllParameterSets();
        if (allOutcomes.isEmpty()) {
            return new ArrayList<TestOutcome>();
        }
        return this.aggregatedScenarioOutcomes(allOutcomes);
    }

    private synchronized List<TestOutcome> aggregatedScenarioOutcomes(List<TestOutcome> allOutcomes) {
        HashMap<String, TestOutcome> scenarioOutcomes = new HashMap<String, TestOutcome>();
        for (TestOutcome testOutcome : allOutcomes) {
            String normalizedMethodName = this.baseMethodName(testOutcome);
            TestOutcome scenarioOutcome = this.scenarioOutcomeFor(normalizedMethodName, testOutcome, scenarioOutcomes);
            this.recordTestOutcomeAsSteps(testOutcome, scenarioOutcome);
            if (testOutcome.isManual()) {
                scenarioOutcome = scenarioOutcome.setToManual();
            }
            if (!testOutcome.isDataDriven()) continue;
            this.updateResultsForAnyExternalFailures(testOutcome, (TestOutcome)scenarioOutcomes.get(normalizedMethodName));
            if (scenarioOutcome.getDataTable() != null) {
                List scenarioRows = scenarioOutcome.getDataTable().getRows();
                List outcomeRows = testOutcome.getDataTable().getRows();
                for (DataTableRow row : outcomeRows) {
                    if (this.containRow(scenarioRows, row)) continue;
                    scenarioOutcome.addRow(row);
                }
                continue;
            }
            scenarioOutcome.addDataFrom(testOutcome.getDataTable());
        }
        ArrayList<TestOutcome> aggregatedScenarioOutcomes = new ArrayList<TestOutcome>();
        aggregatedScenarioOutcomes.addAll(scenarioOutcomes.values());
        return aggregatedScenarioOutcomes;
    }

    private boolean containRow(List<DataTableRow> scenarioRows, DataTableRow expectedRow) {
        return scenarioRows.stream().anyMatch(row -> row.equalsIgnoringTheResult((Object)expectedRow));
    }

    private void recordTestOutcomeAsSteps(TestOutcome testOutcome, TestOutcome scenarioOutcome) {
        String name = this.alternativeMethodName(testOutcome);
        TestStep nestedStep = TestStep.forStepCalled((String)name).withResult(testOutcome.getResult());
        List testSteps = testOutcome.getTestSteps();
        if (testOutcome.getTestFailureCause() != null) {
            nestedStep.failedWith(testOutcome.getTestFailureCause().getOriginalCause());
        }
        if (!testSteps.isEmpty()) {
            for (TestStep nextStep : testSteps) {
                nextStep.setDescription(this.normalizeTestStepDescription(nextStep.getDescription(), scenarioOutcome.getTestSteps().size() + 1));
                nestedStep.addChildStep(nextStep);
                nestedStep.setDuration(nextStep.getDuration() + nestedStep.getDuration());
            }
        }
        if (nestedStep.getDuration() == 0L) {
            nestedStep.setDuration(testOutcome.getDuration().longValue());
        }
        scenarioOutcome.recordStep(nestedStep);
    }

    private TestOutcome scenarioOutcomeFor(String normalizedMethodName, TestOutcome testOutcome, Map<String, TestOutcome> scenarioOutcomes) {
        if (!scenarioOutcomes.containsKey(normalizedMethodName)) {
            TestOutcome scenarioOutcome = this.createScenarioOutcome(testOutcome);
            scenarioOutcomes.put(normalizedMethodName, scenarioOutcome);
        }
        return scenarioOutcomes.get(normalizedMethodName);
    }

    private void updateResultsForAnyExternalFailures(TestOutcome testOutcome, TestOutcome scenarioOutcome) {
        if (this.rowResultsAreInconsistantWithOverallResult(testOutcome)) {
            ((DataTableRow)testOutcome.getDataTable().getRows().get(0)).updateResult(testOutcome.getResult());
        }
    }

    private boolean rowResultsAreInconsistantWithOverallResult(TestOutcome testOutcome) {
        TestResult overallRowResult = this.overallResultFrom(testOutcome.getDataTable().getRows());
        return (testOutcome.isError() != false || testOutcome.isFailure() != false || testOutcome.isCompromised() != false) && !testOutcome.getDataTable().getRows().isEmpty() && testOutcome.getResult() != overallRowResult;
    }

    private TestResult overallResultFrom(List<DataTableRow> rows) {
        List resultsOfEachRow = rows.stream().map(DataTableRow::getResult).collect(Collectors.toList());
        return TestResultList.overallResultFrom(resultsOfEachRow);
    }

    private String normalizeTestStepDescription(String description, int index) {
        return StringUtils.replace((String)description, (String)"[1]", (String)("[" + index + "]"));
    }

    private TestOutcome createScenarioOutcome(TestOutcome parameterizedOutcome) {
        TestOutcome testOutcome = TestOutcome.forTest((String)this.baseMethodName(parameterizedOutcome), (Class)parameterizedOutcome.getTestCase());
        return testOutcome;
    }

    private String baseMethodName(TestOutcome testOutcome) {
        return testOutcome.getName().replaceAll("\\[\\d+\\]", "");
    }

    private String alternativeMethodName(TestOutcome testOutcome) {
        Optional qualifier = testOutcome.getQualifier();
        if (qualifier != null && qualifier.isPresent()) {
            return testOutcome.getTitle(false) + " " + (String)testOutcome.getQualifier().get();
        }
        return testOutcome.getTitle();
    }

    public List<TestOutcome> getTestOutcomesForAllParameterSets() {
        ArrayList<TestOutcome> testOutcomes = new ArrayList<TestOutcome>();
        for (TestOutcome testOutcome : this.allTestOutcomes) {
            testOutcomes.add(ParameterizedTestsOutcomeAggregator.withParentStepsMerged(testOutcome));
        }
        return testOutcomes;
    }

    private static TestOutcome withParentStepsMerged(TestOutcome testOutcome) {
        if (testOutcome.getTestSteps().size() == 1 && ((TestStep)testOutcome.getTestSteps().get(0)).getDescription().startsWith("Example ")) {
            String testStepQualifier = ((TestStep)testOutcome.getTestSteps().get(0)).getDescription().replaceAll("Example \\d+:", "");
            List childSteps = ((TestStep)testOutcome.getTestSteps().get(0)).getChildren();
            return testOutcome.withQualifier(testStepQualifier).withSteps(childSteps);
        }
        return testOutcome;
    }
}

