/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.annotations.SingleBrowser;
import net.thucydides.core.model.TestTag;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;

public class JUnit5Tags {
    private static List<Class<? extends Annotation>> SERENITY_SPECIFIC_ANNOTATIONS = Arrays.asList(SingleBrowser.class);
    private static final Collection<? extends TestTag> NO_TAGS = new ArrayList<TestTag>();

    public static List<TestTag> forMethod(Method method) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        tags.addAll(JUnit5Tags.singleTagAnnotationsIn(method));
        tags.addAll(JUnit5Tags.multipleTagAnnotationsIn(method));
        tags.addAll(JUnit5Tags.customAnnotationsAsTagsIn(method));
        tags.addAll(JUnit5Tags.singleClassLevelTagAnnotationsIn(method.getDeclaringClass()));
        tags.addAll(JUnit5Tags.multipleClassLevelTagAnnotationsIn(method.getDeclaringClass()));
        tags.addAll(JUnit5Tags.customAnnotationsAsClassLevelTagsIn(method.getDeclaringClass()));
        return tags;
    }

    private static Collection<? extends TestTag> customAnnotationsAsClassLevelTagsIn(Class<?> declaringClass) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        while (declaringClass != null) {
            for (Class<? extends Annotation> serenitySpecificAnnotation : SERENITY_SPECIFIC_ANNOTATIONS) {
                if (declaringClass.getAnnotation(serenitySpecificAnnotation) == null) continue;
                tags.add(JUnit5Tags.testTagFromAnnotation(serenitySpecificAnnotation));
            }
            declaringClass = declaringClass.getEnclosingClass();
        }
        return tags;
    }

    private static TestTag testTagFromAnnotation(Class<? extends Annotation> serenitySpecificAnnotation) {
        return TestTag.withValue((String)serenitySpecificAnnotation.getSimpleName().toLowerCase());
    }

    private static Collection<? extends TestTag> customAnnotationsAsTagsIn(Method method) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        for (Class<? extends Annotation> serenitySpecificAnnotation : SERENITY_SPECIFIC_ANNOTATIONS) {
            if (method.getAnnotation(serenitySpecificAnnotation) == null) continue;
            tags.add(JUnit5Tags.testTagFromAnnotation(serenitySpecificAnnotation));
        }
        return tags;
    }

    private static Collection<? extends TestTag> singleClassLevelTagAnnotationsIn(Class<?> declaringClass) {
        ArrayList<TestTag> classLevelTestTags = new ArrayList<TestTag>();
        while (declaringClass != null) {
            if (declaringClass.getAnnotation(Tag.class) != null) {
                Tag tag = declaringClass.getAnnotation(Tag.class);
                classLevelTestTags.addAll(JUnit5Tags.junit5TagsAsSerenityTag(tag));
            }
            declaringClass = declaringClass.getEnclosingClass();
        }
        return classLevelTestTags;
    }

    private static Collection<? extends TestTag> multipleClassLevelTagAnnotationsIn(Class<?> declaringClass) {
        ArrayList<TestTag> classLevelTestTags = new ArrayList<TestTag>();
        while (declaringClass != null) {
            if (declaringClass.getAnnotation(Tags.class) != null) {
                Tag[] tags = declaringClass.getAnnotation(Tags.class).value();
                classLevelTestTags.addAll(JUnit5Tags.junit5TagsAsSerenityTags(tags));
            }
            declaringClass = declaringClass.getEnclosingClass();
        }
        return classLevelTestTags;
    }

    private static Collection<? extends TestTag> multipleTagAnnotationsIn(Method method) {
        if (method.getAnnotation(Tags.class) != null) {
            Tag[] tags = method.getAnnotation(Tags.class).value();
            return JUnit5Tags.junit5TagsAsSerenityTags(tags);
        }
        return NO_TAGS;
    }

    private static Collection<? extends TestTag> singleTagAnnotationsIn(Method method) {
        if (method.getAnnotation(Tag.class) != null) {
            Tag tag = method.getAnnotation(Tag.class);
            return JUnit5Tags.junit5TagsAsSerenityTag(tag);
        }
        return NO_TAGS;
    }

    private static List<TestTag> junit5TagsAsSerenityTag(Tag tag) {
        return Collections.singletonList(TestTag.withValue((String)tag.value()));
    }

    private static List<TestTag> junit5TagsAsSerenityTags(Tag[] tags) {
        return Arrays.stream(tags).map(tag -> TestTag.withValue((String)tag.value())).collect(Collectors.toList());
    }
}

