/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extensions;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class TemporaryFolder {
    private File rootFolder;

    public File newFile(String name) throws IOException {
        File result = new File(this.rootFolder, name);
        result.createNewFile();
        return result;
    }

    public File newFolder(String name) throws IOException {
        File result = new File(this.rootFolder, name);
        result.mkdirs();
        return result;
    }

    void prepare() {
        try {
            this.rootFolder = File.createTempFile("junit5-", ".tmp");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.rootFolder.delete();
        this.rootFolder.mkdir();
    }

    void cleanUp() {
        try {
            Files.walkFileTree(this.rootFolder.toPath(), new DeleteAllVisitor());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static class DeleteAllVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteAllVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException exception) throws IOException {
            Files.delete(directory);
            return FileVisitResult.CONTINUE;
        }
    }
}

