/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.finder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.serenitybdd.junit.finder.TestFinderBuilderFactory;
import net.serenitybdd.junit.finder.TestMethodFinder;
import net.serenitybdd.junit.runners.SerenityRunner;
import net.thucydides.core.reflection.ClassFinder;
import net.thucydides.junit.annotations.UseTestDataFrom;
import org.junit.Test;
import org.junit.runner.RunWith;

public abstract class TestFinder {
    protected final String rootPackage;

    protected TestFinder(String rootPackage) {
        this.rootPackage = rootPackage;
    }

    public static TestFinderBuilderFactory thatFinds() {
        return new TestFinderBuilderFactory();
    }

    public abstract List<Class<?>> getClasses();

    public abstract int countTestMethods();

    public TestMethodFinder findTestMethods() {
        return new TestMethodFinder(this);
    }

    protected List<Class<?>> getAllTestClasses() {
        return ClassFinder.loadClasses().annotatedWith(RunWith.class).fromPackage(this.rootPackage);
    }

    protected Set<Class<?>> getNormalTestClasses() {
        HashSet normalTestClasses = new HashSet();
        for (Class<?> testClass : this.getAllTestClasses()) {
            if (!this.normalThucydidesTest(testClass)) continue;
            normalTestClasses.add(testClass);
        }
        return normalTestClasses;
    }

    protected List<Class<?>> getDataDrivenTestClasses() {
        return ClassFinder.loadClasses().annotatedWith(UseTestDataFrom.class).fromPackage(this.rootPackage);
    }

    protected List<Class<?>> sorted(List<Class<?>> classes) {
        classes.sort(this.byClassName());
        return classes;
    }

    private boolean normalThucydidesTest(Class<?> testClass) {
        RunWith runWith = testClass.getAnnotation(RunWith.class);
        return runWith != null && runWith.value() == SerenityRunner.class;
    }

    public List<Method> getAllTestMethods() {
        return this.findMethodsFrom(this.getClasses());
    }

    private List<Method> findMethodsFrom(List<Class<?>> testClasses) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> testClass : testClasses) {
            this.addEachMatchingTestMethodFrom(testClass).to(methods);
        }
        methods.sort(this.byName());
        return methods;
    }

    private Comparator<Method> byName() {
        return Comparator.comparing(Method::getName);
    }

    private TestMethodSearchBuilder addEachMatchingTestMethodFrom(Class<?> testClass) {
        return new TestMethodSearchBuilder(testClass);
    }

    private Comparator<Class<?>> byClassName() {
        return Comparator.comparing(Class::getName);
    }

    private static class TestMethodSearchBuilder {
        private final Class<?> testClass;

        private TestMethodSearchBuilder(Class<?> testClass) {
            this.testClass = testClass;
        }

        public void to(List<Method> methods) {
            for (Method method : this.testClass.getMethods()) {
                if (!method.isAnnotationPresent(Test.class)) continue;
                methods.add(method);
            }
        }
    }
}

