/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave.converters;

import java.lang.reflect.Type;
import org.jbehave.core.steps.ParameterConverters;
import org.joda.time.YearMonth;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class YearMonthConverter
implements ParameterConverters.ParameterConverter {
    public static final DateTimeFormatter MONTH_YEAR_FORMAT_WITH_DASH = DateTimeFormat.forPattern((String)"MM-yyyy");
    public static final DateTimeFormatter MONTH_YEAR_FORMAT_WITH_SLASH = DateTimeFormat.forPattern((String)"MM/yyyy");
    public static final DateTimeFormatter YEAR_MONTH_FORMAT_WITH_DASH = DateTimeFormat.forPattern((String)"yyyy-MM");
    public static final DateTimeFormatter YEAR_MONTH_FORMAT_WITH_SLASH = DateTimeFormat.forPattern((String)"yyyy/MM");

    public boolean accept(Type type) {
        if (type instanceof Class) {
            return YearMonth.class.isAssignableFrom((Class)type);
        }
        return false;
    }

    public Object convertValue(String value, Type type) {
        if (this.thereIsADashIn(value)) {
            return this.parseWithDash(value);
        }
        return this.parseWithSlash(value);
    }

    private YearMonth parseWithSlash(String value) {
        if (value.trim().substring(2, 3).equals("/")) {
            return YearMonth.parse((String)value, (DateTimeFormatter)MONTH_YEAR_FORMAT_WITH_SLASH);
        }
        return YearMonth.parse((String)value, (DateTimeFormatter)YEAR_MONTH_FORMAT_WITH_SLASH);
    }

    private YearMonth parseWithDash(String value) {
        if (value.trim().substring(2, 3).equals("-")) {
            return YearMonth.parse((String)value, (DateTimeFormatter)MONTH_YEAR_FORMAT_WITH_DASH);
        }
        return YearMonth.parse((String)value, (DateTimeFormatter)YEAR_MONTH_FORMAT_WITH_DASH);
    }

    private boolean thereIsADashIn(String value) {
        return value.contains("-");
    }
}

