/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.webdriver.capabilities.CapabilityProperty;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;

public class AddCustomCapabilities {
    private final String prefix;
    private boolean withPrefix = false;
    private EnvironmentVariables environmentVariables;

    public AddCustomCapabilities(String prefix) {
        this.prefix = prefix;
        this.environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    public static AddCustomCapabilities startingWith(String prefix) {
        return new AddCustomCapabilities(prefix);
    }

    public AddCustomCapabilities from(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public void to(MutableCapabilities capabilities) {
        List propertiesWithPrefix = this.environmentVariables.getKeys().stream().filter(key -> key.startsWith(this.prefix)).collect(Collectors.toList());
        for (String propertyKey : propertiesWithPrefix) {
            String preparedPropertyKey = this.getPreparedPropertyKey(propertyKey);
            String propertyValue = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{propertyKey}).orElse(null);
            if (!StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
            capabilities.setCapability(preparedPropertyKey, CapabilityProperty.asObject(propertyValue));
            if (!this.withPrefix) continue;
            capabilities.setCapability(propertyKey, CapabilityProperty.asObject(propertyValue));
        }
    }

    private String getPreparedPropertyKey(String propertyKey) {
        String shortenedPropertyKey = propertyKey.replace(this.prefix, "");
        if (shortenedPropertyKey.equals("os.version")) {
            return "os_version";
        }
        if (shortenedPropertyKey.equals("browser.version")) {
            return "browser_version";
        }
        return shortenedPropertyKey;
    }

    public AddCustomCapabilities withAndWithoutPrefixes() {
        this.withPrefix = true;
        return this;
    }
}

