/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.model.configuration.FilePathParser;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;

public class SanitisedBrowserPreferences {
    public static Map<String, Object> cleanUpPathsIn(Map<String, Object> rawPreferences) {
        HashMap<String, Object> preferences = new HashMap<String, Object>();
        rawPreferences.forEach((key, value) -> preferences.put((String)key, SanitisedBrowserPreferences.of(value)));
        return preferences;
    }

    public static List<String> cleanUpPathsIn(List<String> rawPreferences) {
        return rawPreferences.stream().map(value -> SanitisedBrowserPreferences.of(value).toString()).collect(Collectors.toList());
    }

    private static Object of(Object value) {
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        FilePathParser parser = new FilePathParser(environmentVariables);
        if (value instanceof String && SanitisedBrowserPreferences.isMalformedPath(value.toString())) {
            return parser.getInstanciatedPath(value.toString());
        }
        return value;
    }

    private static boolean isMalformedPath(String value) {
        try {
            Paths.get(value, new String[0]).toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }
}

