/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.sessions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.serenitybdd.core.SessionMap;
import net.serenitybdd.model.collect.NewMap;

public class TestSessionVariables<K, V>
extends ConcurrentHashMap<K, V>
implements SessionMap<K, V> {
    private final Map<String, String> metadata = new ConcurrentHashMap<String, String>();

    @Override
    public void shouldContainKey(Object key) {
        Object result = super.get(key);
        if (result == null) {
            throw new AssertionError((Object)("Session variable " + String.valueOf(key) + " expected but not found."));
        }
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            return this.remove(key);
        }
        return super.put(key, value);
    }

    @Override
    public Map<String, String> getMetaData() {
        return NewMap.copyOf(this.metadata);
    }

    @Override
    public void addMetaData(String key, String value) {
        this.metadata.put(key, value);
    }

    @Override
    public void clearMetaData() {
        this.metadata.clear();
    }

    @Override
    public void clear() {
        this.clearMetaData();
        super.clear();
    }
}

