/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.injectors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.annotations.Fields;
import net.serenitybdd.core.environment.WebDriverConfiguredEnvironment;
import net.serenitybdd.model.di.DependencyInjector;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.webdriver.Configuration;

public class EnvironmentDependencyInjector
implements DependencyInjector {
    private final EnvironmentVariables environmentVariables = ConfiguredEnvironment.getEnvironmentVariables();
    private final Configuration systemPropertiesConfiguration = ConfiguredEnvironment.getConfiguration();
    private final DriverConfiguration webDriverConfiguration = WebDriverConfiguredEnvironment.getDriverConfiguration();
    private static final List<Field> NO_FIELDS = new ArrayList<Field>();

    public void injectDependenciesInto(Object target) {
        List<Field> environmentVariableFields = this.matchingFieldsIn(target, EnvironmentVariables.class);
        for (Field field : environmentVariableFields) {
            this.injectEnvironmentVariables(field, target);
        }
        List<Field> sysDriverConfigVariableFields = this.matchingFieldsIn(target, DriverConfiguration.class);
        for (Field sysConfigVariableField : sysDriverConfigVariableFields) {
            this.injectDriverConfigVariables(sysConfigVariableField, target);
        }
        List<Field> list = this.matchingFieldsIn(target, Configuration.class);
        for (Field sysConfigVariableField : list) {
            if (sysDriverConfigVariableFields.contains(sysConfigVariableField)) continue;
            this.injectSysConfigVariables(sysConfigVariableField, target);
        }
    }

    public void reset() {
    }

    private void injectEnvironmentVariables(Field field, Object target) {
        try {
            field.setAccessible(true);
            if (field.get(target) == null) {
                field.set(target, this.environmentVariables);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instanciate environmentVariables in " + String.valueOf(target));
        }
    }

    private void injectSysConfigVariables(Field field, Object target) {
        try {
            field.setAccessible(true);
            if (field.get(target) == null) {
                field.set(target, this.systemPropertiesConfiguration);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instanciate systemPropertiesConfiguration in " + String.valueOf(target));
        }
    }

    private void injectDriverConfigVariables(Field field, Object target) {
        try {
            field.setAccessible(true);
            if (field.get(target) == null) {
                field.set(target, this.webDriverConfiguration);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instanciate webDriverConfiguration in " + String.valueOf(target));
        }
    }

    private List<Field> matchingFieldsIn(Object target, Class fieldClass) {
        if (target == null) {
            return NO_FIELDS;
        }
        Set allFields = Fields.of(target.getClass()).allFields();
        return allFields.stream().filter(field -> fieldClass.isAssignableFrom(field.getType())).collect(Collectors.toList());
    }
}

