/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.di;

import java.util.Optional;
import net.serenitybdd.core.annotations.findby.di.ClasspathCustomFindByAnnotationProviderService;
import net.serenitybdd.core.annotations.findby.di.CustomFindByAnnotationProviderService;
import net.serenitybdd.model.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.model.buildinfo.PropertyBasedDriverCapabilityRecord;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.model.time.SystemClock;
import net.thucydides.core.annotations.locators.SmartElementProxyCreator;
import net.thucydides.core.annotations.locators.SmartWidgetProxyCreator;
import net.thucydides.core.configuration.WebDriverConfiguration;
import net.thucydides.core.fixtureservices.ClasspathFixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.webdriver.CloseBrowser;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.core.webdriver.ElementProxyCreator;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverCloseBrowser;
import net.thucydides.core.webdriver.WidgetProxyCreator;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.batches.BatchManager;
import net.thucydides.model.batches.BatchStrategy;
import net.thucydides.model.batches.SystemVariableBasedBatchManager;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.logging.ConsoleLoggingListener;
import net.thucydides.model.statistics.AtomicTestCount;
import net.thucydides.model.statistics.TestCount;
import net.thucydides.model.steps.StepListener;
import net.thucydides.model.steps.di.ClasspathDependencyInjectorService;
import net.thucydides.model.steps.di.DependencyInjectorService;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.webdriver.Configuration;

public class SerenityInfrastructure {
    private static final DependencyInjectorService dependencyInjectorService = new ClasspathDependencyInjectorService();
    private static final ThreadLocal<CloseBrowser> closeBrowser = ThreadLocal.withInitial(() -> new WebdriverCloseBrowser(SerenityInfrastructure.getEnvironmentVariables()));
    private static final CustomFindByAnnotationProviderService customFindByAnnotationProviderService = new ClasspathCustomFindByAnnotationProviderService();
    private static final FixtureProviderService fixtureProviderService = new ClasspathFixtureProviderService();
    private static ConsoleLoggingListener consoleLoggingListener;
    private static Formatter formatter;
    private static final ElementProxyCreator elementProxyCreator;
    private static final WidgetProxyCreator widgetProxyCreator;
    private static final TestCount testCount;
    private static BatchManager batchManager;

    public static DependencyInjectorService getDependencyInjectorService() {
        return dependencyInjectorService;
    }

    public static SystemClock getClock() {
        return ModelInfrastructure.getClock();
    }

    public static EnvironmentVariables getEnvironmentVariables() {
        return SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    public static Configuration getConfiguration() {
        return ModelInfrastructure.getConfiguration();
    }

    public static DriverCapabilityRecord getDriverCapabilityRecord() {
        return new PropertyBasedDriverCapabilityRecord(SerenityInfrastructure.getConfiguration());
    }

    public static DriverConfiguration getDriverConfiguration() {
        return new WebDriverConfiguration(SerenityInfrastructure.getEnvironmentVariables());
    }

    public static CustomFindByAnnotationProviderService getCustomFindByAnnotationProviderService() {
        return customFindByAnnotationProviderService;
    }

    public static WebDriverFactory getWebDriverFactory() {
        return new WebDriverFactory(SerenityInfrastructure.getEnvironmentVariables(), fixtureProviderService, closeBrowser.get());
    }

    public static FixtureProviderService getFixtureProviderService() {
        return fixtureProviderService;
    }

    public static CloseBrowser getCloseBrowser() {
        return closeBrowser.get();
    }

    public static StepListener getLoggingListener() {
        if (consoleLoggingListener == null) {
            consoleLoggingListener = new ConsoleLoggingListener(SerenityInfrastructure.getEnvironmentVariables());
        }
        return consoleLoggingListener;
    }

    public static ElementProxyCreator getElementProxyCreator() {
        return elementProxyCreator;
    }

    public static WidgetProxyCreator getWidgetProxyCreator() {
        return widgetProxyCreator;
    }

    public static TestCount getTestCount() {
        return testCount;
    }

    public static Formatter getFormatter() {
        if (formatter == null) {
            formatter = new Formatter(SerenityInfrastructure.getEnvironmentVariables());
        }
        return formatter;
    }

    public static BatchManager getBatchManager() {
        if (batchManager == null) {
            Optional batchStrategy = EnvironmentSpecificConfiguration.from((EnvironmentVariables)SerenityInfrastructure.getEnvironmentVariables()).getOptionalProperty(ThucydidesSystemProperty.SERENITY_BATCH_STRATEGY);
            if (batchStrategy.isPresent()) {
                try {
                    batchManager = BatchStrategy.valueOf((String)((String)batchStrategy.get())).instance(SerenityInfrastructure.getEnvironmentVariables());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            } else {
                batchManager = new SystemVariableBasedBatchManager(SerenityInfrastructure.getEnvironmentVariables());
            }
        }
        return batchManager;
    }

    public static void resetBatchManager() {
        batchManager = null;
    }

    static {
        elementProxyCreator = new SmartElementProxyCreator();
        widgetProxyCreator = new SmartWidgetProxyCreator();
        testCount = new AtomicTestCount();
    }
}

