/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.jquery;

import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import org.openqa.selenium.WebDriver;

public class JQueryEnabledPage {
    private final WebDriver driver;
    private final EnvironmentVariables environmentVariables;

    protected JQueryEnabledPage(WebDriver driver) {
        this(driver, SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    protected JQueryEnabledPage(WebDriver driver, EnvironmentVariables environmentVariables) {
        this.driver = driver;
        this.environmentVariables = environmentVariables;
    }

    public static JQueryEnabledPage withDriver(WebDriver driver) {
        return new JQueryEnabledPage(driver);
    }

    public boolean isJQueryIntegrationEnabled() {
        boolean jqueryIntegrationEnabled = Boolean.valueOf(ThucydidesSystemProperty.SERENITY_JQUERY_INTEGRATION.from(this.environmentVariables, "true"));
        return jqueryIntegrationEnabled;
    }

    public boolean isJQueryAvailable() {
        boolean jqueryIntegrationEnabled = this.isJQueryIntegrationEnabled();
        if (jqueryIntegrationEnabled && JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            try {
                JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
                Boolean result = (Boolean)js.executeScript("return (typeof jQuery === 'function')");
                return result != null && result != false;
            }
            catch (RuntimeException jsExecutionFailed) {
                return false;
            }
        }
        return false;
    }

    public void injectJQuery() {
        this.executeScriptFrom("jquery/jquery.min.js");
        this.executeScriptFrom("jquery/jquery.focus.test-fix.js");
    }

    protected void executeScriptFrom(String scriptSource) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            String script = this.getFileAsString(scriptSource);
            JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
            js.executeScript(script);
        }
    }

    private String getFileAsString(String resourcePath) {
        String content = "";
        try {
            URL fileUrl = this.getClass().getClassLoader().getResource(resourcePath);
            content = Resources.toString((URL)fileUrl, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    public void injectJQueryPlugins() {
        if (ThucydidesSystemProperty.SERENITY_ACTIVATE_HIGHLIGHTING.booleanFrom(this.environmentVariables).booleanValue()) {
            this.executeScriptFrom("jquery/jquery-thucydides-plugin.js");
        }
    }

    public void injectJavaScriptUtils() {
        this.executeScriptFrom("javascript/cycle.js");
    }

    public void activateJQuery() {
        if (this.isJQueryIntegrationEnabled() && !this.isJQueryAvailable()) {
            this.injectJQuery();
            this.injectJQueryPlugins();
        }
    }
}

