/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import java.io.File;
import net.serenitybdd.core.webdriver.servicepools.DriverPathConfiguration;
import net.serenitybdd.core.webdriver.servicepools.DriverServiceExecutable;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.StopServiceHook;
import net.thucydides.core.ThucydidesSystemProperty;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerServicePool
extends DriverServicePool<InternetExplorerDriverService> {
    @Override
    protected String serviceName() {
        return "iexplorer";
    }

    @Override
    protected WebDriver newDriverInstance(Capabilities capabilities) {
        InternetExplorerOptions options = new InternetExplorerOptions();
        options.merge(capabilities);
        return new InternetExplorerDriver(options);
    }

    @Override
    protected InternetExplorerDriverService newDriverService() {
        InternetExplorerDriverService newService = (InternetExplorerDriverService)((InternetExplorerDriverService.Builder)((InternetExplorerDriverService.Builder)new InternetExplorerDriverService.Builder().usingDriverExecutable(this.driverExecutable())).usingAnyFreePort()).build();
        DriverPathConfiguration.updateSystemProperty(ThucydidesSystemProperty.WEBDRIVER_IE_DRIVER.getPropertyName()).withExecutablePath(this.driverExecutable());
        Runtime.getRuntime().addShutdownHook(new StopServiceHook((DriverService)newService));
        return newService;
    }

    private File driverExecutable() {
        return DriverServiceExecutable.called("IEDriverServer.exe").withSystemProperty(ThucydidesSystemProperty.WEBDRIVER_IE_DRIVER.getPropertyName()).usingEnvironmentVariables(this.environmentVariables).reportMissingBinary().downloadableFrom("https://github.com/SeleniumHQ/selenium/wiki/InternetExplorerDriver").asAFile();
    }
}

