/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;

public class BaseListenerPools {
    private static final Map<ThreadGroup, Map<String, BaseStepListener>> THREAD_GROUP_LISTENERS = new HashMap<ThreadGroup, Map<String, BaseStepListener>>();

    public static void useAThreadForEachActorIn(ThreadGroup currentThreadGroup) {
        HashMap stepEventBusForParentThread = new HashMap();
        THREAD_GROUP_LISTENERS.put(currentThreadGroup, stepEventBusForParentThread);
    }

    public static boolean isUsingAThreadForEachActor() {
        return THREAD_GROUP_LISTENERS.containsKey(Thread.currentThread().getThreadGroup());
    }

    public static BaseStepListener baseStepListenerFor(StepEventBus eventBus) {
        Map<String, BaseStepListener> stepEventBusesPerThread = THREAD_GROUP_LISTENERS.get(Thread.currentThread().getThreadGroup());
        if (!stepEventBusesPerThread.containsKey(BaseListenerPools.currentActivityIdentifier())) {
            stepEventBusesPerThread.put(BaseListenerPools.currentActivityIdentifier(), BaseListenerPools.mainStepListener().childListenerFor(eventBus));
        }
        return stepEventBusesPerThread.get(Thread.currentThread());
    }

    private static String currentActivityIdentifier() {
        return Serenity.getCurrentSession().get("ACTIVITY").toString();
    }

    private static BaseStepListener mainStepListener() {
        return THREAD_GROUP_LISTENERS.get(Thread.currentThread().getThreadGroup()).entrySet().stream().map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalStateException("No main thread found"));
    }

    private static Stream<BaseStepListener> childStepListeners() {
        return THREAD_GROUP_LISTENERS.get(Thread.currentThread().getThreadGroup()).entrySet().stream().map(Map.Entry::getValue);
    }

    public static void mergeParallelActivityFlows(ThreadGroup currentThreadGroup) {
        BaseStepListener mainStepListener = BaseListenerPools.mainStepListener();
        BaseListenerPools.childStepListeners().forEach(baseStepListener -> System.out.println(baseStepListener));
        THREAD_GROUP_LISTENERS.remove(currentThreadGroup);
    }
}

