/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.net.MalformedURLException;
import net.serenitybdd.core.webdriver.driverproviders.DefaultRemoteDriver;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.RemoteWebdriverStub;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;

public class RemoteDriverProvider
implements DriverProvider {
    private final FixtureProviderService fixtureProviderService;

    public RemoteDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) throws MalformedURLException {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return RemoteWebdriverStub.from(environmentVariables);
        }
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        DriverCapabilities remoteDriverCapabilities = new DriverCapabilities(environmentVariables, enhancer);
        WebDriver driver = new DefaultRemoteDriver(environmentVariables, remoteDriverCapabilities).buildWithOptions(options);
        return new Augmenter().augment(driver);
    }
}

