/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.webdriver.WebDriverInstanceEventListener;
import net.thucydides.core.webdriver.WebDriverLifecycleEvent;
import org.openqa.selenium.WebDriver;

public class WebDriverInstanceEvents {
    private List<WebDriverInstanceEventListener> LISTENERS = Collections.synchronizedList(new ArrayList());
    private static WebDriverInstanceEvents eventsBus = new WebDriverInstanceEvents();

    public static WebDriverInstanceEvents bus() {
        return eventsBus;
    }

    public void register(WebDriverInstanceEventListener listener) {
        this.LISTENERS.add(listener);
    }

    public WebDriverInstanceEventBuilder notifyOf(WebDriverLifecycleEvent event) {
        return new WebDriverInstanceEventBuilder(event);
    }

    public class WebDriverInstanceEventBuilder {
        private final WebDriverLifecycleEvent event;

        WebDriverInstanceEventBuilder(WebDriverLifecycleEvent event) {
            this.event = event;
        }

        public void forDriver(WebDriver driver) {
            WebDriverInstanceEvents.this.LISTENERS.forEach(listener -> {
                switch (this.event) {
                    case CLOSE: {
                        listener.close(driver);
                        break;
                    }
                    case QUIT: {
                        listener.quit(driver);
                    }
                }
            });
        }
    }
}

