/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import java.util.Arrays;
import java.util.List;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class WebElementExpectations {
    private static final List<String> HTML_FORM_TAGS = Arrays.asList("input", "button", "select", "textarea", "link", "option");

    public static ExpectedCondition<Boolean> elementIsDisplayed(WebElementFacade element) {
        return new ExpectedCondition<Boolean>(){
            private WebElementFacade element;

            public ExpectedCondition<Boolean> forElement(WebElementFacade element) {
                this.element = element;
                return this;
            }

            public Boolean apply(WebDriver driver) {
                return this.element.isCurrentlyVisible();
            }

            public String toString() {
                return this.element.toString() + " to be displayed";
            }
        }.forElement(element);
    }

    public static ExpectedCondition<Boolean> elementIsPresent(WebElementFacade element) {
        return new ExpectedCondition<Boolean>(){
            private WebElementFacade element;

            public ExpectedCondition<Boolean> forElement(WebElementFacade element) {
                this.element = element;
                return this;
            }

            public Boolean apply(WebDriver driver) {
                return this.element.isPresent();
            }

            public String toString() {
                return this.element.toString() + " to be present";
            }
        }.forElement(element);
    }

    public static ExpectedCondition<Boolean> elementIsEnabled(WebElementFacadeImpl element) {
        return new ExpectedCondition<Boolean>(){
            private WebElementFacadeImpl element;

            public ExpectedCondition<Boolean> forElement(WebElementFacadeImpl element) {
                this.element = element;
                return this;
            }

            public Boolean apply(WebDriver driver) {
                WebElement resolvedElement = this.element.getElement();
                return resolvedElement != null && !WebElementExpectations.isDisabledField(this.element);
            }

            public String toString() {
                return this.element.toString() + " to be enabled";
            }
        }.forElement(element);
    }

    public static ExpectedCondition<Boolean> elementIsNotEnabled(WebElementFacade element) {
        return new ExpectedCondition<Boolean>(){
            private WebElementFacade element;

            public ExpectedCondition<Boolean> forElement(WebElementFacade element) {
                this.element = element;
                return this;
            }

            public Boolean apply(WebDriver driver) {
                return this.element.isDisabled();
            }

            public String toString() {
                return this.element.toString() + " to not be enabled";
            }
        }.forElement(element);
    }

    public static ExpectedCondition<Boolean> elementIsClickable(WebElementFacadeImpl element) {
        return new ExpectedCondition<Boolean>(){
            private WebElementFacadeImpl element;

            public ExpectedCondition<Boolean> forElement(WebElementFacadeImpl element) {
                this.element = element;
                return this;
            }

            public Boolean apply(WebDriver driver) {
                WebElement resolvedElement = this.element.getElement();
                return resolvedElement != null && resolvedElement.isDisplayed() && resolvedElement.isEnabled();
            }

            public String toString() {
                return this.element.toString() + " to be clickable";
            }
        }.forElement(element);
    }

    public static ExpectedCondition<Boolean> elementIsNotDisplayed(WebElementFacade element) {
        return new ExpectedCondition<Boolean>(){
            private WebElementFacade element;

            public ExpectedCondition<Boolean> forElement(WebElementFacade element) {
                this.element = element;
                return this;
            }

            public Boolean apply(WebDriver driver) {
                return !this.element.isCurrentlyVisible();
            }

            public String toString() {
                return this.element.toString() + " to be not displayed";
            }
        }.forElement(element);
    }

    public static ExpectedCondition<Boolean> elementIsNotPresent(WebElementFacade element) {
        return new ExpectedCondition<Boolean>(){
            private WebElementFacade element;

            public ExpectedCondition<Boolean> forElement(WebElementFacade element) {
                this.element = element;
                return this;
            }

            public Boolean apply(WebDriver driver) {
                return !this.element.isPresent();
            }

            public String toString() {
                return this.element.toString() + " to be not present";
            }
        }.forElement(element);
    }

    private static boolean isDisabledField(WebElement element) {
        return WebElementExpectations.isAFormElement(element) && !element.isEnabled();
    }

    private static boolean isAFormElement(WebElement element) {
        if (element == null || element.getTagName() == null) {
            return false;
        }
        String tag = element.getTagName().toLowerCase();
        return HTML_FORM_TAGS.contains(tag);
    }
}

