/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import java.io.File;
import net.serenitybdd.core.webdriver.servicepools.DriverPathConfiguration;
import net.serenitybdd.core.webdriver.servicepools.DriverServiceExecutable;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.StopServiceHook;
import net.thucydides.core.ThucydidesSystemProperty;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeServicePool
extends DriverServicePool<ChromeDriverService> {
    @Override
    protected String serviceName() {
        return "chrome";
    }

    @Override
    protected WebDriver newDriverInstance(Capabilities capabilities) {
        return new ChromeDriver(capabilities);
    }

    @Override
    protected ChromeDriverService newDriverService() {
        boolean silent = this.environmentVariables.getPropertyAsBoolean("chrome.silent", true);
        boolean verbose = this.environmentVariables.getPropertyAsBoolean("chrome.verbose", false);
        ChromeDriverService newService = (ChromeDriverService)((ChromeDriverService.Builder)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingDriverExecutable(this.chromeDriverExecutable())).usingAnyFreePort()).withSilent(silent).withVerbose(verbose).build();
        DriverPathConfiguration.updateSystemProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_DRIVER.getPropertyName()).withExecutablePath(this.chromeDriverExecutable());
        Runtime.getRuntime().addShutdownHook(new StopServiceHook((DriverService)newService));
        return newService;
    }

    private File chromeDriverExecutable() {
        File executable = DriverServiceExecutable.called("chromedriver").withSystemProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_DRIVER.getPropertyName()).usingEnvironmentVariables(this.environmentVariables).reportMissingBinary().downloadableFrom("https://sites.google.com/a/chromium.org/chromedriver/downloads").asAFile();
        return executable;
    }
}

