/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.File;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.time.InternalSystemClock;
import net.serenitybdd.core.webdriver.driverproviders.AddEnvironmentSpecifiedDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.AddLoggingPreferences;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.ProvideNewDriver;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.serenitybdd.core.webdriver.servicepools.DriverServiceExecutable;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.InternetExplorerServicePool;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetExplorerDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(InternetExplorerDriverProvider.class);
    private final DriverServicePool driverServicePool = new InternetExplorerServicePool();
    private final EnvironmentVariables environmentVariables;
    private final FixtureProviderService fixtureProviderService;

    public InternetExplorerDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        this.updateIEDriverBinaryIfSpecified();
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        DesiredCapabilities desiredCapabilities = enhancer.enhanced(this.recommendedDefaultInternetExplorerCapabilities(), SupportedWebDriver.IEXPLORER);
        SetProxyConfiguration.from(environmentVariables).in(desiredCapabilities);
        AddLoggingPreferences.from(environmentVariables).to(desiredCapabilities);
        this.driverProperties.registerCapabilities("iexplorer", this.capabilitiesToProperties((Capabilities)desiredCapabilities));
        return ProvideNewDriver.withConfiguration(environmentVariables, desiredCapabilities, this.driverServicePool, this::retryCreateDriverOnNoSuchSession, (pool, caps) -> new InternetExplorerDriver(new InternetExplorerOptions((Capabilities)caps)));
    }

    private WebDriver retryCreateDriverOnNoSuchSession(DriverServicePool pool, DesiredCapabilities desiredCapabilities) {
        return new TryAtMost(3).toStartNewDriverWith(pool, desiredCapabilities);
    }

    private DesiredCapabilities recommendedDefaultInternetExplorerCapabilities() {
        DesiredCapabilities defaults = DesiredCapabilities.internetExplorer();
        defaults.setCapability("ignoreZoomSetting", (Object)ThucydidesSystemProperty.IE_OPTIONS_IGNORE_ZOOM_LEVEL.booleanFrom(this.environmentVariables, Boolean.valueOf(true)));
        defaults.setCapability("nativeEvents", (Object)ThucydidesSystemProperty.IE_OPTIONS_ENABLE_NATIVE_EVENTS.booleanFrom(this.environmentVariables, Boolean.valueOf(true)));
        defaults.setCapability("requireWindowFocus", (Object)ThucydidesSystemProperty.IE_OPTIONS_REQUIRE_WINDOW_FOCUS.booleanFrom(this.environmentVariables, Boolean.valueOf(false)));
        defaults.setCapability("takesScreenshot", true);
        defaults.setJavascriptEnabled(true);
        defaults = AddEnvironmentSpecifiedDriverCapabilities.from(this.environmentVariables).forDriver(SupportedWebDriver.IEXPLORER).to(defaults);
        if (ThucydidesSystemProperty.ACCEPT_INSECURE_CERTIFICATES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            defaults.acceptInsecureCerts();
        }
        return defaults;
    }

    private void updateIEDriverBinaryIfSpecified() {
        File executable = DriverServiceExecutable.called("InternetExplorerDriver.exe").withSystemProperty(ThucydidesSystemProperty.WEBDRIVER_IE_DRIVER.getPropertyName()).usingEnvironmentVariables(this.environmentVariables).reportMissingBinary().downloadableFrom("https://github.com/SeleniumHQ/selenium/wiki/InternetExplorerDriver").asAFile();
        if (executable != null && executable.exists()) {
            System.setProperty("webdriver.ie.driver", executable.getAbsolutePath());
        }
    }

    private class TryAtMost {
        private final int maxTries;

        private TryAtMost(int maxTries) {
            this.maxTries = maxTries;
        }

        public WebDriver toStartNewDriverWith(DriverServicePool pool, DesiredCapabilities desiredCapabilities) {
            try {
                return pool.newDriver((Capabilities)desiredCapabilities);
            }
            catch (NoSuchSessionException e) {
                if (this.maxTries == 0) {
                    throw e;
                }
                LOGGER.error(((Object)((Object)e)).getClass().getCanonicalName() + " happened - retrying in 2 seconds");
                new InternalSystemClock().pauseFor(2000L);
                return new TryAtMost(this.maxTries - 1).toStartNewDriverWith(pool, desiredCapabilities);
            }
        }
    }
}

