/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.openqa.selenium.WebDriver;

public class TimeoutStack {
    Map<WebDriver, Stack<Duration>> timeouts = new HashMap<WebDriver, Stack<Duration>>();

    public void pushTimeoutFor(WebDriver driver, Duration implicitTimeout) {
        if (!this.timeouts.containsKey(driver)) {
            this.timeouts.put(driver, new Stack());
        }
        this.timeouts.get(driver).push(implicitTimeout);
    }

    public Optional<Duration> popTimeoutFor(WebDriver driver) {
        if (this.timeouts.containsKey(driver)) {
            return this.timeouts.get(driver).isEmpty() ? Optional.empty() : Optional.of(this.timeouts.get(driver).pop());
        }
        return Optional.empty();
    }

    public Boolean containsTimeoutFor(WebDriver driver) {
        return this.timeouts.containsKey(driver) && !this.timeouts.get(driver).isEmpty();
    }

    public Optional<Duration> currentTimeoutValueFor(WebDriver driver) {
        if (this.containsTimeoutFor(driver).booleanValue()) {
            return Optional.of(this.timeouts.get(driver).peek());
        }
        return Optional.empty();
    }

    public void releaseTimeoutFor(WebDriver driverInstance) {
        this.timeouts.remove(driverInstance);
    }
}

