/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Predicate;
import java.time.Duration;
import org.openqa.selenium.WebDriver;

public abstract class AbstractObjectInitialiser<T>
implements Predicate<T> {
    protected final WebDriver driver;
    protected final Duration ajaxTimeout;

    public AbstractObjectInitialiser(WebDriver driver, long ajaxTimeoutInMilliseconds) {
        this.driver = driver;
        this.ajaxTimeout = Duration.ofMillis(ajaxTimeoutInMilliseconds);
    }

    protected int ajaxTimeoutInSecondsWithAtLeast1Second() {
        return (int)(this.ajaxTimeout.getSeconds() > 0L ? this.ajaxTimeout.getSeconds() : 1L);
    }

    public abstract boolean apply(T var1);

    public boolean test(T input) {
        return this.apply(input);
    }
}

