/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.pages.WebElementResolver;
import net.thucydides.core.annotations.locators.MethodTiming;
import net.thucydides.core.annotations.locators.WithConfigurableTimeout;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.ConfigurableTimeouts;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class WebElementResolverByElementLocator
extends WebElementResolver {
    private final ElementLocator locator;
    private final long implicitTimeoutInMilliseconds;

    public WebElementResolverByElementLocator(ElementLocator locator, long implicitTimeoutInMilliseconds) {
        this.locator = locator;
        this.implicitTimeoutInMilliseconds = implicitTimeoutInMilliseconds;
    }

    @Override
    public WebElement resolveForDriver(WebDriver driver) {
        if (this.locator == null) {
            return null;
        }
        WebElement resolvedELement = this.getLocatorWithDriver(driver).findElement();
        this.ensureVisibilityOf(resolvedELement);
        return resolvedELement;
    }

    @Override
    public List<WebElement> resolveAllForDriver(WebDriver driver) {
        if (this.locator == null) {
            return Collections.emptyList();
        }
        return this.getLocatorWithDriver(driver).findElements();
    }

    private void ensureVisibilityOf(WebElement resolvedELement) {
        if (resolvedELement == null) {
            throw new ElementNotVisibleException(this.locator.toString());
        }
    }

    private ElementLocator getLocatorWithDriver(WebDriver driver) {
        if (this.locator instanceof WithConfigurableTimeout && driver instanceof ConfigurableTimeouts) {
            ((WithConfigurableTimeout)this.locator).setTimeOutInSeconds((int)this.getLocatorTimeout());
        }
        return this.locator;
    }

    private long getLocatorTimeout() {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended() || MethodTiming.forThisThread().isInQuickMethod()) {
            return 0L;
        }
        return TimeUnit.SECONDS.convert(this.implicitTimeoutInMilliseconds, TimeUnit.MILLISECONDS);
    }
}

