/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.javascript;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.pages.jquery.JQueryEnabledPage;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class JavascriptExecutorFacade {
    private WebDriver driver;
    private Map<Type, Object> typeAdapters = new HashMap<Type, Object>();
    private static final Map<String, Object> NO_INJECTABLE_FIELDS = new HashMap<String, Object>();

    public JavascriptExecutorFacade(WebDriver driver) {
        this();
        this.driver = driver;
    }

    public JavascriptExecutorFacade() {
    }

    protected Gson getGson() {
        GsonBuilder builder = new GsonBuilder();
        for (Type type : this.typeAdapters.keySet()) {
            builder.registerTypeAdapter(type, this.typeAdapters.get(type));
        }
        return builder.create();
    }

    public void registerTypeAdapter(Type type, Object typeAdapter) {
        this.typeAdapters.put(type, typeAdapter);
    }

    public Object executeScript(String script) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            JavascriptExecutor js = this.getJavascriptEnabledDriver();
            return js.executeScript(script, new Object[0]);
        }
        return null;
    }

    public Object executeScript(String script, Object ... params) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver) && this.shouldExecuteJavascript()) {
            JavascriptExecutor js = this.getJavascriptEnabledDriver();
            return js.executeScript(script, params);
        }
        return null;
    }

    public Object executeAsyncScript(String script) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            JavascriptExecutor js = this.getJavascriptEnabledDriver();
            return js.executeAsyncScript(script, new Object[0]);
        }
        return null;
    }

    public Object executeAsyncScript(String script, Object ... params) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver) && this.shouldExecuteJavascript()) {
            JavascriptExecutor js = this.getJavascriptEnabledDriver();
            return js.executeAsyncScript(script, params);
        }
        return null;
    }

    private boolean shouldExecuteJavascript() {
        return !StepEventBus.getEventBus().webdriverCallsAreSuspended() && !StepEventBus.getEventBus().isDryRun() && !StepEventBus.getEventBus().currentTestIsSuspended();
    }

    private String executeAndGetJsonAsString(String script, Object ... params) {
        JQueryEnabledPage jQueryEnabledPage = JQueryEnabledPage.withDriver(this.getRealDriver());
        jQueryEnabledPage.injectJavaScriptUtils();
        return (String)this.executeScript("return JSON.stringify(JSON.decycle(function(arguments){" + script + "}(arguments)));", params);
    }

    private <T> T deserializeJsonAs(Class<T> classOfT, String objString) {
        return (T)this.getGson().fromJson(objString, classOfT);
    }

    private <T> List<T> deserializeJsonAsListOf(String objString) {
        Type listOfT = new TypeToken<List<T>>(){}.getType();
        return (List)this.getGson().fromJson(objString, listOfT);
    }

    public <T> T deserializeScriptResultAs(Class<T> classOfT, String script, Map<String, Object> injectedFields, Object ... params) throws IllegalAccessException {
        String objString = this.executeAndGetJsonAsString(script, params);
        return objString == null ? null : (T)this.injectParametersInto(this.deserializeJsonAs(classOfT, objString), injectedFields);
    }

    public <T> T deserializeScriptResultAs(Class<T> classOfT, String script, Object ... params) throws IllegalAccessException {
        String objString = this.executeAndGetJsonAsString(script, params);
        return objString == null ? null : (T)this.injectParametersInto(this.deserializeJsonAs(classOfT, objString), NO_INJECTABLE_FIELDS);
    }

    private <T> T injectParametersInto(T t, Map<String, Object> params) throws IllegalAccessException {
        for (String fieldName : params.keySet()) {
            Object value = params.get(fieldName);
            FieldUtils.writeField(t, (String)fieldName, (Object)value, (boolean)true);
        }
        return t;
    }

    public <T> List<T> deserializeScriptResultAsListOf(String script, Object ... params) {
        String objString = this.executeAndGetJsonAsString(script, params);
        if (objString == null) {
            return null;
        }
        return this.deserializeJsonAsListOf(objString);
    }

    private WebDriver getRealDriver() {
        if (WebDriverFacade.class.isAssignableFrom(this.driver.getClass())) {
            WebDriverFacade driverFacade = (WebDriverFacade)this.driver;
            return driverFacade.getProxiedDriver();
        }
        return this.driver;
    }

    private JavascriptExecutor getJavascriptEnabledDriver() {
        return (JavascriptExecutor)this.getRealDriver();
    }
}

