/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.io.Resources;
import java.io.File;
import java.nio.file.Paths;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;

public class FeatureOrStoryFile {
    private final String filename;
    private final FeatureOrStory type;
    private final EnvironmentVariables environmentVariables;

    public FeatureOrStoryFile(String filename, FeatureOrStory type) {
        this.filename = filename;
        this.type = type;
        this.environmentVariables = ConfiguredEnvironment.getEnvironmentVariables();
    }

    public static FeatureOrStoryFile forFeatureDescribedIn(String filename) {
        return new FeatureOrStoryFile(filename, FeatureOrStory.features);
    }

    public static FeatureOrStoryFile forStoryDescribedIn(String filename) {
        return new FeatureOrStoryFile(filename, FeatureOrStory.stories);
    }

    public File asFile() {
        if (Paths.get(this.filename, new String[0]).toFile().exists()) {
            return Paths.get(this.filename, new String[0]).toFile();
        }
        String requirementsDirectory = ThucydidesSystemProperty.THUCYDIDES_REQUIREMENTS_DIR.from(this.environmentVariables, this.type.name());
        String featureFileOnClassPath = this.filename.startsWith(requirementsDirectory) ? this.filename : requirementsDirectory + "/" + this.filename;
        try {
            return Paths.get(Resources.getResource((String)featureFileOnClassPath).getFile(), new String[0]).toFile();
        }
        catch (IllegalArgumentException featureFileNotOnClasspath) {
            return Paths.get(this.filename, new String[0]).toFile();
        }
    }

    static enum FeatureOrStory {
        features,
        stories;

    }
}

