/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.scheduling;

import com.google.common.base.Preconditions;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.thucydides.core.scheduling.PollingSchedule;
import net.thucydides.core.scheduling.TimeoutSchedule;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.TemporalUnitConverter;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.Wait;

public abstract class ThucydidesFluentWait<T>
implements Wait<T> {
    protected Duration timeout = Duration.ofMillis(500L);
    protected Duration interval = Duration.ofMillis(50L);
    private List<Class<? extends RuntimeException>> ignoredExceptions = new LinkedList<Class<? extends RuntimeException>>();
    private final Clock clock;
    private final T input;
    private final Sleeper sleeper;
    private Supplier<String> messageSupplier = () -> null;

    public ThucydidesFluentWait(T input, Clock clock, Sleeper sleeper) {
        this.input = Preconditions.checkNotNull(input);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)sleeper);
    }

    protected Clock getClock() {
        return this.clock;
    }

    protected T getInput() {
        return this.input;
    }

    protected Sleeper getSleeper() {
        return this.sleeper;
    }

    public <V> V until(Function<? super T, V> isTrue) {
        long end = this.getClock().millis() + this.timeout.toMillis();
        RuntimeException lastException = null;
        String waitForConditionMessage = isTrue.toString();
        while (true) {
            block9: {
                if (this.aPreviousStepHasFailed()) {
                    return (V)Boolean.TRUE;
                }
                try {
                    V value = isTrue.apply(this.input);
                    if (value != null && Boolean.class.equals(value.getClass())) {
                        if (Boolean.TRUE.equals(value)) {
                            return value;
                        }
                        break block9;
                    }
                    throw new IllegalArgumentException("Condition should be a boolean function");
                }
                catch (RuntimeException e) {
                    lastException = this.propagateIfNotIngored(e);
                }
            }
            if (this.getClock().millis() >= end) {
                String message = this.messageSupplier != null ? this.messageSupplier.get() : null;
                String timeoutMessage = String.format("Expected condition failed: %s (tried for %d second(s) with %d milliseconds interval)", message == null ? "waiting for " + isTrue : message, this.timeout.getSeconds(), this.interval.toMillis());
                throw this.timeoutException(timeoutMessage, lastException);
            }
            try {
                this.doWait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    private boolean aPreviousStepHasFailed() {
        return StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed();
    }

    public abstract void doWait() throws InterruptedException;

    private RuntimeException propagateIfNotIngored(RuntimeException e) {
        for (Class<? extends RuntimeException> ignoredException : this.ignoredExceptions) {
            if (!ignoredException.isInstance(e)) continue;
            return e;
        }
        throw e;
    }

    public ThucydidesFluentWait<T> ignoring(Class<? extends RuntimeException> ... types) {
        this.ignoredExceptions.addAll(Arrays.asList(types));
        return this;
    }

    public ThucydidesFluentWait<T> withTimeout(long duration, TimeUnit unit) {
        this.timeout = Duration.of(duration, TemporalUnitConverter.fromTimeUnit(unit));
        return this;
    }

    public ThucydidesFluentWait<T> withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public ThucydidesFluentWait<T> withMessage(String message) {
        this.messageSupplier = () -> message;
        return this;
    }

    public ThucydidesFluentWait<T> withMessage(Supplier<String> messageSupplier) {
        this.messageSupplier = messageSupplier;
        return this;
    }

    public ThucydidesFluentWait<T> pollingEvery(long duration, TimeUnit unit) {
        this.interval = Duration.of(duration, TemporalUnitConverter.fromTimeUnit(unit));
        return this;
    }

    protected RuntimeException timeoutException(String message, RuntimeException lastException) {
        throw new TimeoutException(message, (Throwable)lastException);
    }

    public TimeoutSchedule withTimeoutOf(int amount) {
        return new TimeoutSchedule(this, amount);
    }

    public PollingSchedule pollingEvery(int amount) {
        return new PollingSchedule(this, amount);
    }
}

