/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import net.serenitybdd.core.webdriver.servicepools.DisabledGeckoDriverService;
import net.serenitybdd.core.webdriver.servicepools.GeckoDriverServiceExecutable;
import net.serenitybdd.core.webdriver.servicepools.StopServiceHook;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.remote.service.DriverService;

public class ThreadsafeGeckoDriverService
extends GeckoDriverService {
    ThreadLocal<GeckoDriverService> threadLocalDriverService = new ThreadLocal();
    private final EnvironmentVariables environmentVariables;

    public ThreadsafeGeckoDriverService(EnvironmentVariables environmentVariables) throws IOException {
        super(new File(""), 0, null, null);
        this.environmentVariables = environmentVariables;
    }

    public static GeckoDriverService createThreadsafeService(EnvironmentVariables environmentVariables) {
        try {
            return new ThreadsafeGeckoDriverService(environmentVariables);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create threadsafe service", e);
        }
    }

    protected GeckoDriverService getThreadlocalGeckoService() {
        if (this.threadLocalDriverService.get() == null) {
            DisabledGeckoDriverService newService;
            Optional<File> geckoExecutable = GeckoDriverServiceExecutable.inEnvironment(this.environmentVariables);
            if (geckoExecutable.isPresent()) {
                newService = (GeckoDriverService)((GeckoDriverService.Builder)((GeckoDriverService.Builder)new GeckoDriverService.Builder().usingDriverExecutable(geckoExecutable.get())).usingAnyFreePort()).build();
                Runtime.getRuntime().addShutdownHook(new StopServiceHook((DriverService)newService));
            } else {
                newService = DisabledGeckoDriverService.build();
            }
            this.threadLocalDriverService.set(newService);
        }
        return this.threadLocalDriverService.get();
    }

    public URL getUrl() {
        return this.getThreadlocalGeckoService().getUrl();
    }

    public boolean isRunning() {
        return this.getThreadlocalGeckoService().isRunning();
    }

    public void start() throws IOException {
        this.getThreadlocalGeckoService().start();
    }

    public void stop() {
        this.getThreadlocalGeckoService().stop();
    }
}

