/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.gson.JsonObject;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;

public class SetProxyConfiguration {
    private final EnvironmentVariables environmentVariables;

    public SetProxyConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static SetProxyConfiguration from(EnvironmentVariables environmentVariables) {
        return new SetProxyConfiguration(environmentVariables);
    }

    public void in(MutableCapabilities capabilities) {
        String proxyUrl = ThucydidesSystemProperty.SERENITY_PROXY_HTTP.from(this.environmentVariables);
        String proxyPort = ThucydidesSystemProperty.SERENITY_PROXY_HTTP_PORT.from(this.environmentVariables);
        String sslProxy = ThucydidesSystemProperty.SERENITY_PROXY_SSL.from(this.environmentVariables, proxyUrl);
        String sslProxyPort = ThucydidesSystemProperty.SERENITY_PROXY_SSL_PORT.from(this.environmentVariables);
        Proxy proxy = new Proxy();
        if (proxyUrl != null && !proxyUrl.isEmpty()) {
            JsonObject json = new JsonObject();
            if (StringUtils.isNotEmpty((CharSequence)proxyUrl)) {
                proxy.setHttpProxy(proxyUrl + ":" + proxyPort);
            }
            if (StringUtils.isNotEmpty((CharSequence)sslProxy)) {
                proxy.setSslProxy(sslProxy + ":" + sslProxyPort);
            }
            if (StringUtils.isNotEmpty((CharSequence)sslProxyPort)) {
                json.addProperty("sslProxyPort", sslProxyPort);
            }
            capabilities.setCapability("proxy", (Object)proxy);
        }
    }
}

