/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverBuilder;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.capabilities.SaucelabsRemoteDriverCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;

class SaucelabsDriverBuilder
extends RemoteDriverBuilder {
    private final SaucelabsRemoteDriverCapabilities saucelabsRemoteDriverCapabilities;
    private final DriverCapabilities remoteDriverCapabilities;

    SaucelabsDriverBuilder(EnvironmentVariables environmentVariables, DriverCapabilities remoteDriverCapabilities) {
        super(environmentVariables);
        this.saucelabsRemoteDriverCapabilities = new SaucelabsRemoteDriverCapabilities(environmentVariables);
        this.remoteDriverCapabilities = remoteDriverCapabilities;
    }

    @Override
    WebDriver buildWithOptions(String options) throws MalformedURLException {
        String saucelabsUrl = this.saucelabsRemoteDriverCapabilities.getUrl();
        WebDriver driver = this.newRemoteDriver(new URL(saucelabsUrl), this.findSaucelabsCapabilities(options), options);
        this.setImplicitTimeoutsFor(driver);
        return driver;
    }

    private void setImplicitTimeoutsFor(WebDriver driver) {
        if (StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.from(this.environmentVariables))) {
            int implicitWait = ThucydidesSystemProperty.SAUCELABS_IMPLICIT_TIMEOUT.integerFrom(this.environmentVariables, 30);
            driver.manage().timeouts().implicitlyWait((long)implicitWait, TimeUnit.SECONDS);
        }
    }

    private Capabilities findSaucelabsCapabilities(String options) {
        String driver = WebDriverFactory.getSaucelabsDriverFrom(this.environmentVariables);
        MutableCapabilities capabilities = this.remoteDriverCapabilities.forDriver(driver, options);
        return this.saucelabsRemoteDriverCapabilities.getCapabilities(capabilities);
    }
}

